/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.infoserv.spi;

import org.eclipse.vtp.framework.infoserv.spi.Rule;

public class SeverityRule
extends Rule {
    private int severity = 0;

    public SeverityRule(int severity, int action) {
        super(action);
        if (severity < 0 || severity > 3) {
            throw new IllegalArgumentException("Severity must be 0 (error), 1 (warning), 2 (info), or 3 (debug).  Received " + severity);
        }
        this.severity = severity;
    }

    public boolean matches(String[] categories, int severity) {
        if (severity <= this.severity && this.isAllowed()) {
            return true;
        }
        return severity >= this.severity && !this.isAllowed();
    }

    public Rule deepCopy() {
        int action = 0;
        if (this.isAllowed()) {
            ++action;
        }
        if (this.isFinite()) {
            action += 2;
        }
        return new SeverityRule(this.severity, action);
    }
}

