/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.common.internal.util.Defaultable;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveCopySessionUtility;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.wst.common.internal.emf.utilities.CopyGroup;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class ArchiveCopyUtility
extends EtoolsCopyUtility {
    public ArchiveCopyUtility() {
        this.setCopyAdapters(true);
    }

    protected void addDeferredSingleReferenceCopy(EReference reference, EObject aValue, String idSuffix, EObject aCopyContainer) {
        if (((Defaultable)aValue).isDefault()) {
            return;
        }
        super.addDeferredSingleReferenceCopy(reference, aValue, idSuffix, aCopyContainer);
    }

    public ArchiveManifest copy(ArchiveManifest mf) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            mf.write(out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            return new ArchiveManifestImpl(in);
        }
        catch (IOException iox) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.IOException_occurred_while_EXC_, iox);
        }
    }

    public Archive copy(Archive anArchive) {
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.setPreserveIds(true);
        this.prepareResourcesForCopy(anArchive, copyGroup);
        copyGroup.add((EObject)anArchive);
        this.copy(copyGroup);
        Archive copiedArchive = (Archive)this.getCopy(anArchive);
        this.finishCopy(anArchive, copiedArchive, copyGroup);
        return copiedArchive;
    }

    public ModuleFile copy(ModuleFile aModuleFile) {
        aModuleFile.getStandardDeploymentDescriptor();
        if (aModuleFile.isWARFile()) {
            EList filterMappings = ((WARFile)aModuleFile).getDeploymentDescriptor().getFilterMappings();
            int i = 0;
            while (i < filterMappings.size()) {
                ((FilterMapping)filterMappings.get(i)).getServlet();
                ++i;
            }
        }
        ModuleFile copied = (ModuleFile)this.copy((Archive)aModuleFile);
        return copied;
    }

    public void copy(CopyGroup aGroup) {
        if (aGroup != null) {
            ArchiveCopySessionUtility session = new ArchiveCopySessionUtility(this);
            session.setPreserveIds(aGroup.getPreserveIds());
            session.copy(aGroup);
            session.flush();
        }
    }

    public EObject copy(EObject aRefObject, String idSuffix) {
        ArchiveCopySessionUtility session = new ArchiveCopySessionUtility(this);
        EObject copied = session.copy(aRefObject, idSuffix);
        session.flush();
        return copied;
    }

    public Resource copy(Resource aResource, String newUri) {
        ArchiveCopySessionUtility session = new ArchiveCopySessionUtility(this);
        Resource copied = session.copy(aResource, newUri);
        session.flush();
        return copied;
    }

    protected void copyImportStrategyIfNecessary(ModuleFile aModuleFile, ModuleFile copy) {
        if (!aModuleFile.isDeploymentDescriptorSet()) {
            copy.setImportStrategy(aModuleFile.getImportStrategy().createImportStrategy(aModuleFile, copy));
        }
    }

    public EObject copyObject(EObject aRefObject, String idSuffix) {
        ArchiveCopySessionUtility session = new ArchiveCopySessionUtility(this);
        EObject copied = session.copyObject(aRefObject, idSuffix);
        session.flush();
        return copied;
    }

    public static void createCopy(CopyGroup aGroup) {
        ArchiveCopyUtility utility = new ArchiveCopyUtility();
        utility.copy(aGroup);
    }

    protected void finishCopy(Archive source, Archive copy, CopyGroup group) {
        copy.setLoadStrategy(this.getCommonarchiveFactory().createEmptyLoadStrategy());
        copy.setExtraClasspath(source.getExtraClasspath());
        copy.setXmlEncoding(source.getXmlEncoding());
        if (source.isManifestSet()) {
            copy.setManifest(this.copy(source.getManifest()));
        } else {
            try {
                File manifestToCopy = source.getFile("META-INF/MANIFEST.MF");
                if (manifestToCopy != null) {
                    File copiedManifest = (File)this.getCopy(manifestToCopy);
                    copiedManifest.setLoadingContainer(manifestToCopy.getLoadingContainer());
                    copy.addCopy(copiedManifest);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (DuplicateObjectException duplicateObjectException) {}
        }
        this.retrieveResourcesFromCopy(copy, group);
        if (source.isModuleFile()) {
            this.copyImportStrategyIfNecessary((ModuleFile)source, (ModuleFile)copy);
        }
        EList files = source.getFiles();
        int i = 0;
        while (i < files.size()) {
            File aFile = (File)files.get(i);
            File copiedFile = (File)this.getCopy(aFile);
            copiedFile.setLoadingContainer(aFile.getLoadingContainer());
            if (aFile.isArchive()) {
                this.finishNestedCopy((Archive)aFile, (Archive)copiedFile);
            }
            ++i;
        }
        copy.rebuildFileIndex();
    }

    protected void finishNestedCopy(Archive source, Archive copy) {
        CopyGroup group = new CopyGroup();
        this.prepareResourcesForCopy(source, group);
        this.copy(group);
        this.finishCopy(source, copy, group);
    }

    private CommonarchiveFactory getCommonarchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    protected void prepareResourcesForCopy(Archive anArchive, CopyGroup copyGroup) {
        Iterator iter = anArchive.getLoadedMofResources().iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            if (ArchiveUtil.isJavaResource(resource)) continue;
            copyGroup.add(resource);
        }
    }

    protected void retrieveResourcesFromCopy(Archive copiedArchive, CopyGroup copyGroup) {
        List resources = copyGroup.getCopiedResources();
        int i = 0;
        while (i < resources.size()) {
            Resource copiedResource = (Resource)resources.get(i);
            copiedArchive.addOrReplaceMofResource(copiedResource);
            ++i;
        }
    }
}

