/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.CMRField;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBRelation;
import org.eclipse.jst.j2ee.ejb.EJBRelationshipRole;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.ejb.Relationships;
import org.eclipse.jst.j2ee.ejb.RoleSource;
import org.eclipse.jst.j2ee.model.internal.validation.AValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.DuplicatesTable;
import org.eclipse.jst.j2ee.model.internal.validation.EJBJar20VRule;
import org.eclipse.jst.j2ee.model.internal.validation.EJBValidationRuleFactory;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IMessagePrefixEjb20Constants;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRuleList;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class EJBJar20VRule
extends AValidationRule
implements IMessagePrefixEjb20Constants {
    private static final Map MESSAGE_IDS;
    private DuplicatesTable _ejbName = new DuplicatesTable();
    private DuplicatesTable _asName = new DuplicatesTable();
    private DuplicatesTable _relationshipName = new DuplicatesTable();
    private DuplicatesTable _relationshipRoleName = new DuplicatesTable();
    private static final Object[] DEPENDS_ON;

    static {
        DEPENDS_ON = new Object[]{IValidationRuleList.EJB20_STATELESS_SESSION_BEANCLASS, IValidationRuleList.EJB20_STATELESS_SESSION_REMOTE, IValidationRuleList.EJB20_STATELESS_SESSION_HOME, IValidationRuleList.EJB20_STATELESS_SESSION_LOCAL, IValidationRuleList.EJB20_STATELESS_SESSION_LOCALHOME, IValidationRuleList.EJB20_STATEFUL_SESSION_BEANCLASS, IValidationRuleList.EJB20_STATEFUL_SESSION_REMOTE, IValidationRuleList.EJB20_STATEFUL_SESSION_HOME, IValidationRuleList.EJB20_STATEFUL_SESSION_LOCAL, IValidationRuleList.EJB20_STATEFUL_SESSION_LOCALHOME, IValidationRuleList.EJB20_CMP_BEANCLASS, IValidationRuleList.EJB20_CMP_REMOTE, IValidationRuleList.EJB20_CMP_HOME, IValidationRuleList.EJB20_CMP_LOCAL, IValidationRuleList.EJB20_CMP_LOCALHOME, IValidationRuleList.EJB20_CMP_KEYCLASS, IValidationRuleList.EJB20_BMP_BEANCLASS, IValidationRuleList.EJB20_BMP_REMOTE, IValidationRuleList.EJB20_BMP_HOME, IValidationRuleList.EJB20_BMP_LOCAL, IValidationRuleList.EJB20_BMP_LOCALHOME, IValidationRuleList.EJB20_BMP_KEYCLASS, IValidationRuleList.EJB20_MESSAGE_BEANCLASS, IValidationRuleList.EJB20_EJBEXT};
        MESSAGE_IDS = new HashMap();
        MESSAGE_IDS.put("CHKJ2800.named", new String[]{"CHKJ2800.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2800.unnamed", new String[]{"CHKJ2800.unnamed.ejb20"});
        MESSAGE_IDS.put("CHKJ2802.named", new String[]{"CHKJ2802.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2802.unnamed", new String[]{"CHKJ2802.unnamed.ejb20"});
        MESSAGE_IDS.put("CHKJ2803.named", new String[]{"CHKJ2803.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2803.unnamed", new String[]{"CHKJ2803.unnamed.ejb20"});
        MESSAGE_IDS.put("CHKJ2804.named", new String[]{"CHKJ2804.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2804.unnamed", new String[]{"CHKJ2804.unnamed.ejb20"});
        MESSAGE_IDS.put("CHKJ2805.named", new String[]{"CHKJ2805.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2805.unnamed", new String[]{"CHKJ2805.unnamed.ejb20"});
        MESSAGE_IDS.put("CHKJ2806", new String[]{"CHKJ2806.ejb20"});
        MESSAGE_IDS.put("CHKJ2807", new String[]{"CHKJ2807.ejb20"});
        MESSAGE_IDS.put("CHKJ2808", new String[]{"CHKJ2808.ejb20"});
        MESSAGE_IDS.put("CHKJ2809", new String[]{"CHKJ2809.ejb20"});
        MESSAGE_IDS.put("CHKJ2810.named", new String[]{"CHKJ2810.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2810.unnamed", new String[]{"CHKJ2810.unnamed.ejb20"});
        MESSAGE_IDS.put("CHKJ2811.named", new String[]{"CHKJ2811.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2814", new String[]{"CHKJ2814.ejb20"});
        MESSAGE_IDS.put("CHKJ2816", new String[]{"CHKJ2816.ejb20"});
        MESSAGE_IDS.put("CHKJ2817", new String[]{"CHKJ2817.ejb20"});
        MESSAGE_IDS.put("CHKJ2818", new String[]{"CHKJ2818.ejb20"});
        MESSAGE_IDS.put("CHKJ2820", new String[]{"CHKJ2820.ejb20"});
        MESSAGE_IDS.put("CHKJ2821", new String[]{"CHKJ2821.ejb20"});
        MESSAGE_IDS.put("CHKJ2822", new String[]{"CHKJ2822.ejb20"});
        MESSAGE_IDS.put("CHKJ2823", new String[]{"CHKJ2823.ejb20"});
        MESSAGE_IDS.put("CHKJ2824", new String[]{"CHKJ2824.ejb20"});
        MESSAGE_IDS.put("CHKJ2825", new String[]{"CHKJ2825.ejb20"});
        MESSAGE_IDS.put("CHKJ2826", new String[]{"CHKJ2826.ejb20"});
        MESSAGE_IDS.put("CHKJ2827", new String[]{"CHKJ2827.ejb20"});
        MESSAGE_IDS.put("CHKJ2828", new String[]{"CHKJ2828.ejb20"});
        MESSAGE_IDS.put("CHKJ2829", new String[]{"CHKJ2829.ejb20"});
        MESSAGE_IDS.put("CHKJ2830", new String[]{"CHKJ2830.ejb20"});
        MESSAGE_IDS.put("CHKJ2831", new String[]{"CHKJ2831.ejb20"});
        MESSAGE_IDS.put("CHKJ2832", new String[]{"CHKJ2832.ejb20"});
        MESSAGE_IDS.put("CHKJ2833", new String[]{"CHKJ2833.ejb20"});
        MESSAGE_IDS.put("CHKJ2834", new String[]{"CHKJ2834.ejb20"});
        MESSAGE_IDS.put("CHKJ2835", new String[]{"CHKJ2835.ejb20"});
        MESSAGE_IDS.put("CHKJ2836", new String[]{"CHKJ2836.ejb20"});
        MESSAGE_IDS.put("CHKJ2837", new String[]{"CHKJ2837.ejb20"});
        MESSAGE_IDS.put("CHKJ2838", new String[]{"CHKJ2838.ejb20"});
        MESSAGE_IDS.put("CHKJ2839", new String[]{"CHKJ2839.ejb20"});
        MESSAGE_IDS.put("CHKJ2841", new String[]{"CHKJ2841.ejb20"});
        MESSAGE_IDS.put("CHKJ2842", new String[]{"CHKJ2842.ejb20"});
        MESSAGE_IDS.put("CHKJ2843", new String[]{"CHKJ2843.ejb20"});
        MESSAGE_IDS.put("CHKJ2844", new String[]{"CHKJ2844.ejb20"});
        MESSAGE_IDS.put("CHKJ2845", new String[]{"CHKJ2845.ejb20"});
        MESSAGE_IDS.put("CHKJ2846", new String[]{"CHKJ2846.ejb20"});
        MESSAGE_IDS.put("CHKJ2847", new String[]{"CHKJ2847.ejb20"});
        MESSAGE_IDS.put("CHKJ2848", new String[]{"CHKJ2848.ejb20"});
        MESSAGE_IDS.put("CHKJ2850", new String[]{"CHKJ2850.ejb20"});
        MESSAGE_IDS.put("CHKJ2854", new String[]{"CHKJ2854.ejb20"});
        MESSAGE_IDS.put("CHKJ2855", new String[]{"CHKJ2855.ejb20"});
        MESSAGE_IDS.put("CHKJ2856", new String[]{"CHKJ2856.ejb20"});
        MESSAGE_IDS.put("CHKJ2857", new String[]{"CHKJ2857.ejb20"});
        MESSAGE_IDS.put("CHKJ2858", new String[]{"CHKJ2858.ejb20"});
        MESSAGE_IDS.put("CHKJ2859", new String[]{"CHKJ2859.ejb20"});
        MESSAGE_IDS.put("CHKJ2860", new String[]{"CHKJ2860.ejb20"});
        MESSAGE_IDS.put("CHKJ2866", new String[]{"CHKJ2866.ejb20"});
        MESSAGE_IDS.put("CHKJ2867", new String[]{"CHKJ2867.ejb20"});
        MESSAGE_IDS.put("CHKJ2868", new String[]{"CHKJ2868.ejb20"});
        MESSAGE_IDS.put("CHKJ2869", new String[]{"CHKJ2869.ejb20"});
        MESSAGE_IDS.put("CHKJ2871", new String[]{"CHKJ2871.ejb20"});
        MESSAGE_IDS.put("CHKJ2872", new String[]{"CHKJ2872.ejb20"});
        MESSAGE_IDS.put("CHKJ2873", new String[]{"CHKJ2873.ejb20"});
        MESSAGE_IDS.put("CHKJ2874", new String[]{"CHKJ2874.ejb20"});
        MESSAGE_IDS.put("CHKJ2875", new String[]{"CHKJ2875.ejb20"});
        MESSAGE_IDS.put("CHKJ2895", new String[]{"CHKJ2895.ejb20"});
        MESSAGE_IDS.put("CHKJ2852", new String[]{"CHKJ2852"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }

    public Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public Object getId() {
        return IValidationRuleList.EJB20_EJBJAR;
    }

    public Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public Object getTarget(Object parent, Object clazz) {
        return null;
    }

    public void reset() {
        super.reset();
        this._ejbName.clear();
        this._asName.clear();
        this._relationshipName.clear();
        this._relationshipRoleName.clear();
    }

    protected void addInternalErrorMessage(IEJBValidationContext vc, Throwable exc) {
        Logger logger;
        IMessage mssg = vc.getMessage();
        mssg.setId("CHKJ2900");
        vc.addMessage(mssg);
        if (exc != null && (logger = vc.getMsgLogger()) != null && logger.isLoggingLevel(Level.SEVERE)) {
            logger.write(Level.SEVERE, exc);
        }
    }

    protected void logMissingRule(IEJBValidationContext vc, Object ruleId) {
        this.log(vc, ruleId + " = null");
        this.addInternalErrorMessage(vc, null);
    }

    protected void log(IEJBValidationContext vc, String message) {
        Logger logger = vc.getMsgLogger();
        if (logger != null && logger.isLoggingLevel(Level.SEVERE)) {
            logger.write(Level.SEVERE, message);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationCancelledException, ValidationException {
        Logger logger = vc.getMsgLogger();
        if (logger != null && logger.isLoggingLevel(Level.FINEST)) {
            LogEntry entry = vc.getLogEntry();
            entry.setSourceID("EJBJar20VRule - validate");
            entry.setText(String.valueOf(this.getClass().getName()) + "::validate(" + targetParent + ", " + target);
            logger.write(Level.FINEST, (Object)entry);
        }
        EJBJar ejbJar = (EJBJar)target;
        EList beans = ejbJar.getEnterpriseBeans();
        Iterator iterator = beans.iterator();
        EnterpriseBean bean = null;
        block15: while (true) {
            IMessage message;
            if (!iterator.hasNext()) {
                this.validateAssemblyDescriptorElement(vc, ejbJar);
                this.validateUniqueEjbNames(vc, ejbJar);
                this.validateUniqueAbstractSchemaNames(vc, ejbJar);
                this.validateRelationships(vc, ejbJar);
                this.validateClientJAR(vc, ejbJar);
                return;
            }
            try {
                Object var12_17;
                bean = (EnterpriseBean)iterator.next();
                this.register(vc, ejbJar, bean);
                Object id = null;
                switch (bean.getVersionID()) {
                    case 10: 
                    case 11: {
                        id = IValidationRuleList.EJB11_ENTERPRISEBEAN;
                        break;
                    }
                    case 20: 
                    case 21: {
                        id = IValidationRuleList.EJB20_ENTERPRISEBEAN;
                        break;
                    }
                    default: {
                        if (bean instanceof ContainerManagedEntity) {
                            this.validateCMPVersionElement(vc, ejbJar, (ContainerManagedEntity)bean);
                            continue block15;
                        }
                        this.log(vc, "!bean.isVersion1_X() && !bean.isVersion2_X()");
                        continue block15;
                    }
                }
                IValidationRule vRule = EJBValidationRuleFactory.getFactory().getRule(vc, id);
                if (vRule == null) {
                    this.logMissingRule(vc, id);
                    continue;
                }
                try {
                    try {
                        vRule.preValidate(vc, ejbJar, bean);
                        vRule.validate(vc, ejbJar, bean);
                        vRule.postValidate(vc, ejbJar, bean);
                    }
                    catch (ValidationCancelledException exc) {
                        throw exc;
                    }
                    catch (ValidationException e) {
                        throw e;
                    }
                    catch (Throwable exc) {
                        this.addInternalErrorMessage(vc, exc);
                    }
                }
                catch (Throwable throwable) {
                    var12_17 = null;
                    EJBValidationRuleFactory.getFactory().release(vRule);
                    throw throwable;
                }
                {
                    var12_17 = null;
                    EJBValidationRuleFactory.getFactory().release(vRule);
                    continue;
                }
            }
            catch (ValidationCancelledException e) {
                throw e;
            }
            catch (ValidationException exc) {
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2852", 2, bean, new String[]{"ejb-jar.xml", bean.getName()}, (IValidationRule)this);
                vc.addMessage(message);
                if (!logger.isLoggingLevel(Level.SEVERE)) continue;
                logger.write(Level.SEVERE, (Exception)((Object)exc));
                continue;
            }
            catch (Throwable exc) {
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2852", 2, bean, new String[]{"ejb-jar.xml", bean.getName()}, (IValidationRule)this);
                vc.addMessage(message);
                if (!logger.isLoggingLevel(Level.SEVERE)) continue;
                logger.write(Level.SEVERE, exc);
                continue;
            }
            break;
        }
    }

    protected void register(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        this._ejbName.add(new EjbNameWrapper(bean));
        if (bean instanceof ContainerManagedEntity && bean.getVersionID() >= 20) {
            this._asName.add(new ASNameWrapper((ContainerManagedEntity)bean));
        }
    }

    protected void validateCMPVersionElement(IEJBValidationContext vc, EJBJar ejbJar, ContainerManagedEntity cmp) {
        String version;
        if (cmp.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getContainerManagedEntity_Version()) && !"1.x".equals(version = cmp.getVersion()) && !"2.x".equals(version)) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2872", 1, cmp, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateAssemblyDescriptorElement(IEJBValidationContext vc, EJBJar ejbJar) {
        vc.terminateIfCancelled();
        if (ejbJar == null) {
            return;
        }
        AssemblyDescriptor assemblyDescriptor = ejbJar.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        EList roles = assemblyDescriptor.getSecurityRoles();
        if (roles != null) {
            class RoleWrapper {
                private SecurityRole _role;
                final /* synthetic */ EJBJar20VRule this$0;

                public RoleWrapper(EJBJar20VRule eJBJar20VRule, SecurityRole role) {
                    this.this$0 = eJBJar20VRule;
                    this._role = null;
                    this._role = role;
                }

                public boolean equals(Object o) {
                    if (o instanceof RoleWrapper) {
                        RoleWrapper other = (RoleWrapper)o;
                        return this._role.getRoleName().equals(other.getRole().getRoleName());
                    }
                    return false;
                }

                public SecurityRole getRole() {
                    return this._role;
                }
            }
            DuplicatesTable roleNames = new DuplicatesTable();
            SecurityRole role = null;
            Iterator roleIt = roles.iterator();
            while (roleIt.hasNext()) {
                vc.terminateIfCancelled();
                role = (SecurityRole)roleIt.next();
                if (role == null || !role.eIsSet((EStructuralFeature)CommonPackage.eINSTANCE.getSecurityRole_RoleName()) || role.getRoleName().equals("")) {
                    IMessage message;
                    if (role == null) {
                        message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2825", 2, role, (IValidationRule)this);
                        vc.addMessage(message);
                        continue;
                    }
                    message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2825", 2, assemblyDescriptor, (IValidationRule)this);
                    vc.addMessage(message);
                    continue;
                }
                roleNames.add(new RoleWrapper(this, role));
            }
            if (roleNames.containsDuplicates()) {
                List duplicates = roleNames.getDuplicates();
                Iterator iterator = duplicates.iterator();
                while (iterator.hasNext()) {
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2826", 2, ((RoleWrapper)iterator.next()).getRole(), (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            roleNames.clear();
        }
        EList methTrans = assemblyDescriptor.getMethodTransactions();
        MethodTransaction mt = null;
        Iterator iterator = methTrans.iterator();
        while (iterator.hasNext()) {
            vc.terminateIfCancelled();
            try {
                mt = (MethodTransaction)iterator.next();
            }
            catch (Throwable exc) {
                Logger logger = vc.getMsgLogger();
                if (logger != null && logger.isLoggingLevel(Level.FINER)) {
                    logger.write(Level.FINER, exc);
                }
                mt = null;
            }
            if (mt == null) {
                Logger logger = vc.getMsgLogger();
                if (logger == null || !logger.isLoggingLevel(Level.FINEST)) continue;
                LogEntry entry = vc.getLogEntry();
                entry.setSourceID("EJBJar20VRule.validateAssemblyDescriptorElement");
                entry.setText("mt is null");
                logger.write(Level.FINEST, (Object)entry);
                continue;
            }
            boolean hasValidMethod = this.validateMethodElements(vc, ejbJar, (List)mt.getMethodElements());
            if (hasValidMethod) continue;
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2847", 2, mt, (IValidationRule)this);
            vc.addMessage(message);
        }
        EList methodPermissions = assemblyDescriptor.getMethodPermissions();
        iterator = methodPermissions.iterator();
        while (iterator.hasNext()) {
            EList mproles;
            MethodPermission mp = (MethodPermission)iterator.next();
            boolean hasValidMethod = this.validateMethodElements(vc, ejbJar, (List)mp.getMethodElements());
            if (!hasValidMethod) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2846", 2, mp, (IValidationRule)this);
                vc.addMessage(message);
            }
            if ((mproles = mp.getRoles()) != null && mproles.size() != 0 || mp.isSetUnchecked()) continue;
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2845", 2, mp, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateUniqueAbstractSchemaNames(IEJBValidationContext vc, EJBJar ejbJar) {
        List names = this._asName.getDuplicates();
        if (names.size() == 0) {
            return;
        }
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            ASNameWrapper wrapper = (ASNameWrapper)iterator.next();
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2854", 1, (EnterpriseBean)wrapper.getBean(), new String[]{wrapper.getBean().getAbstractSchemaName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateUniqueEjbNames(IEJBValidationContext vc, EJBJar ejbJar) {
        List names = this._ejbName.getDuplicates();
        if (names.size() == 0) {
            return;
        }
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            EjbNameWrapper wrapper = (EjbNameWrapper)iterator.next();
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2895", 2, wrapper.getBean(), new String[]{wrapper.getBean().getName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateRelationships(IEJBValidationContext vc, EJBJar ejbJar) {
        Relationships relationships = ejbJar.getRelationshipList();
        if (relationships == null) {
            return;
        }
        EList ejbRelationList = relationships.getEjbRelations();
        Iterator iterator = ejbRelationList.iterator();
        while (iterator.hasNext()) {
            EJBRelation relation = (EJBRelation)iterator.next();
            this._relationshipName.add(new EJBRelationNameWrapper(relation));
            boolean atLeastOneCmrFieldExists = false;
            EList roles = relation.getRelationshipRoles();
            Iterator roleIterator = roles.iterator();
            while (roleIterator.hasNext()) {
                ContainerManagedEntity targetEntity;
                IMessage message;
                RoleSource sourceRoleSource;
                IMessage message2;
                CMRField cmrField;
                EJBRelationshipRole role = (EJBRelationshipRole)roleIterator.next();
                this._relationshipRoleName.add(new EJBRelationshipRoleNameWrapper(role));
                boolean validMultiplicity = role.isSetMultiplicity();
                if (!validMultiplicity) {
                    IMessage message3 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2818", 4, role, (IValidationRule)this);
                    vc.addMessage(message3);
                }
                EJBRelationshipRole oppositeRole = role.getOpposite();
                if (role.isSetCascadeDelete()) {
                    boolean isOtherMultiplicityOne;
                    boolean bl = isOtherMultiplicityOne = oppositeRole.isSetMultiplicity() && oppositeRole.getMultiplicity().getValue() == 0;
                    if (!isOtherMultiplicityOne) {
                        IMessage message4 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2848", 4, role, (IValidationRule)this);
                        vc.addMessage(message4);
                    }
                }
                if ((cmrField = role.getCmrField()) != null) {
                    String cmrFieldType;
                    atLeastOneCmrFieldExists = true;
                    if (cmrField.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getCMRField_CollectionType()) && !"java.util.Collection".equals(cmrFieldType = cmrField.getCollectionTypeName()) && !"java.util.Set".equals(cmrFieldType)) {
                        message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2868", 4, role, (IValidationRule)this);
                        vc.addMessage(message2);
                    }
                }
                if ((sourceRoleSource = role.getSource()) == null) {
                    message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2821", 4, role, new String[]{role.getName()}, (IValidationRule)this);
                    vc.addMessage(message2);
                    continue;
                }
                ContainerManagedEntity sourceEntity = sourceRoleSource.getEntityBean();
                if (sourceEntity == null) {
                    message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2821", 4, role, new String[]{role.getName()}, (IValidationRule)this);
                    vc.addMessage(message);
                } else if (sourceEntity.isContainerManagedEntity()) {
                    if (cmrField != null) {
                        ContainerManagedEntity cmp = sourceEntity;
                        List cmrFields = cmp.getCMRFields();
                        boolean found_cmrField = false;
                        if (cmrFields != null && cmrFields.size() > 0) {
                            found_cmrField = cmrFields.contains(cmrField);
                        }
                        if (!found_cmrField) {
                            IMessage message5 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2866", 4, role, new String[]{cmrField.getName(), sourceEntity.getName()}, (IValidationRule)this);
                            vc.addMessage(message5);
                        }
                    }
                } else {
                    message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2871", 4, role, new String[]{sourceEntity.getName()}, (IValidationRule)this);
                    vc.addMessage(message);
                }
                RoleSource oppositeRoleSource = oppositeRole.getSource();
                if (oppositeRoleSource == null || (targetEntity = oppositeRoleSource.getEntityBean()) == null || targetEntity.getLocalInterface() != null) continue;
                IMessage message6 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2867", 4, oppositeRole, (IValidationRule)this);
                vc.addMessage(message6);
            }
            this.validateUniqueRelationshipRoleNames(vc, ejbJar);
            this._relationshipRoleName.clear();
            if (atLeastOneCmrFieldExists) continue;
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2869", 4, relation, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateUniqueRelationNames(vc, ejbJar);
    }

    protected void validateUniqueRelationNames(IEJBValidationContext vc, EJBJar ejbJar) {
        List names = this._relationshipName.getDuplicates();
        if (names.size() == 0) {
            return;
        }
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            EJBRelationNameWrapper wrapper = (EJBRelationNameWrapper)iterator.next();
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2816", 4, wrapper.getRelation(), new String[]{wrapper.getRelation().getName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateUniqueRelationshipRoleNames(IEJBValidationContext vc, EJBJar ejbJar) {
        List names = this._relationshipRoleName.getDuplicates();
        if (names.size() == 0) {
            return;
        }
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            EJBRelationshipRoleNameWrapper wrapper = (EJBRelationshipRoleNameWrapper)iterator.next();
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2817", 4, wrapper.getRelationshipRole(), new String[]{wrapper.getRelationshipRole().getName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected boolean validateMethodElements(IEJBValidationContext vc, EJBJar ejbJar, List elements) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean hasValidMethod = false;
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            IMessage message;
            vc.terminateIfCancelled();
            MethodElement element = (MethodElement)iterator.next();
            EnterpriseBean bean = element.getEnterpriseBean();
            if (bean == null) {
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2814", 2, element, (IValidationRule)this);
                vc.addMessage(message);
                continue;
            }
            if (element.getName() != null) {
                List params;
                boolean hasMethods;
                String name = element.getName();
                Method[] methods = element.getMethods();
                boolean bl = hasMethods = methods != null && methods.length > 0;
                if (!hasMethods) {
                    IMessage message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2843", 2, element, new String[]{bean.getName()}, (IValidationRule)this);
                    vc.addMessage(message2);
                    continue;
                }
                hasValidMethod = true;
                if (!name.equals("*") || (params = element.getMethodParams()) == null || params.size() <= 0) continue;
                IMessage message3 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2842", 2, element, (IValidationRule)this);
                vc.addMessage(message3);
                continue;
            }
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2844", 2, element, (IValidationRule)this);
            vc.addMessage(message);
        }
        return hasValidMethod;
    }

    protected void validateClientJAR(IEJBValidationContext vc, EJBJar ejbJar) {
        String clientJARName = ejbJar.getEjbClientJar();
        if (clientJARName == null) {
            return;
        }
        Boolean exists = (Boolean)vc.loadModel("EJB_CLIENTJAR", new Object[]{clientJARName});
        if (exists == null) {
            return;
        }
        if (!exists.booleanValue()) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2875", 1, ejbJar, new String[]{clientJARName}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    class ASNameWrapper {
        private ContainerManagedEntity _bean = null;

        public ASNameWrapper(ContainerManagedEntity bean) {
            this._bean = bean;
        }

        public boolean equals(Object o) {
            if (o instanceof ASNameWrapper) {
                ASNameWrapper other = (ASNameWrapper)o;
                if (this._bean.getAbstractSchemaName() == null && other.getBean().getAbstractSchemaName() == null) {
                    return true;
                }
                if (this._bean.getAbstractSchemaName() == null) {
                    return false;
                }
                if (other.getBean().getAbstractSchemaName() == null) {
                    return false;
                }
                return this._bean.getAbstractSchemaName().equals(other.getBean().getAbstractSchemaName());
            }
            return false;
        }

        public int hashCode() {
            if (this.getBean() != null && this.getBean().getAbstractSchemaName() != null) {
                return this.getBean().getAbstractSchemaName().hashCode();
            }
            return super.hashCode();
        }

        public ContainerManagedEntity getBean() {
            return this._bean;
        }
    }

    class EJBRelationNameWrapper {
        private EJBRelation _relation = null;

        public EJBRelationNameWrapper(EJBRelation rel) {
            this._relation = rel;
        }

        public boolean equals(Object o) {
            if (o instanceof EJBRelationNameWrapper) {
                EJBRelationNameWrapper other = (EJBRelationNameWrapper)o;
                if (this._relation.getName() == null && other.getRelation().getName() == null) {
                    return true;
                }
                if (this._relation.getName() == null) {
                    return false;
                }
                if (other.getRelation().getName() == null) {
                    return false;
                }
                return this._relation.getName().equals(other.getRelation().getName());
            }
            return false;
        }

        public int hashCode() {
            if (this.getRelation() != null && this.getRelation().getName() != null) {
                return this.getRelation().getName().hashCode();
            }
            return super.hashCode();
        }

        public EJBRelation getRelation() {
            return this._relation;
        }
    }

    class EJBRelationshipRoleNameWrapper {
        private EJBRelationshipRole _relationshipRole = null;

        public EJBRelationshipRoleNameWrapper(EJBRelationshipRole role) {
            this._relationshipRole = role;
        }

        public boolean equals(Object o) {
            if (o instanceof EJBRelationshipRoleNameWrapper) {
                EJBRelationshipRoleNameWrapper other = (EJBRelationshipRoleNameWrapper)o;
                if (this._relationshipRole.getRoleName() == null && other.getRelationshipRole().getRoleName() == null) {
                    return true;
                }
                if (this._relationshipRole.getRoleName() == null) {
                    return false;
                }
                if (other.getRelationshipRole().getRoleName() == null) {
                    return false;
                }
                return this._relationshipRole.getRoleName().equals(other.getRelationshipRole().getRoleName());
            }
            return false;
        }

        public int hashCode() {
            if (this.getRelationshipRole() != null && this.getRelationshipRole().getRoleName() != null) {
                return this.getRelationshipRole().getRoleName().hashCode();
            }
            return super.hashCode();
        }

        public EJBRelationshipRole getRelationshipRole() {
            return this._relationshipRole;
        }
    }

    class EjbNameWrapper {
        private EnterpriseBean _bean = null;

        public EjbNameWrapper(EnterpriseBean bean) {
            this._bean = bean;
        }

        public boolean equals(Object o) {
            if (o instanceof EjbNameWrapper) {
                EjbNameWrapper other = (EjbNameWrapper)o;
                if (this._bean.getName() == null && other.getBean().getName() == null) {
                    return true;
                }
                if (this._bean.getName() == null) {
                    return false;
                }
                if (other.getBean().getName() == null) {
                    return false;
                }
                return this._bean.getName().equals(other.getBean().getName());
            }
            return false;
        }

        public int hashCode() {
            if (this.getBean() != null && this.getBean().getName() != null) {
                return this.getBean().getName().hashCode();
            }
            return super.hashCode();
        }

        public EnterpriseBean getBean() {
            return this._bean;
        }
    }
}

