/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.infoserv.core;

import java.util.Properties;
import org.eclipse.vtp.framework.infoserv.api.InformationService;
import org.eclipse.vtp.framework.infoserv.api.Logger;
import org.eclipse.vtp.framework.infoserv.core.DefaultInformant;

public class DefaultLogger
extends DefaultInformant
implements Logger {
    private String[] loggingCategory = new String[]{"LOGGING"};

    public DefaultLogger(InformationService informationService) {
        super(informationService);
    }

    public void info(String message) {
        this.informationService.inform(this.loggingCategory, 2, message, this.emptyProperties);
    }

    public void info(String message, Properties properties) {
        this.informationService.inform(this.loggingCategory, 2, message, properties);
    }

    public void info(String[] categories, String message) {
        this.informationService.inform(this.combineCategories(categories), 2, message, this.emptyProperties);
    }

    public void info(String[] categories, String message, Properties properties) {
        this.informationService.inform(this.combineCategories(categories), 2, message, properties);
    }

    public void debug(String message) {
        this.informationService.inform(this.loggingCategory, 2, message, this.emptyProperties);
    }

    public void debug(String message, Properties properties) {
        this.informationService.inform(this.loggingCategory, 3, message, properties);
    }

    public void debug(String[] categories, String message) {
        this.informationService.inform(this.combineCategories(categories), 3, message, this.emptyProperties);
    }

    public void debug(String[] categories, String message, Properties properties) {
        this.informationService.inform(this.combineCategories(categories), 3, message, properties);
    }

    public void warn(String message) {
        this.informationService.inform(this.loggingCategory, 1, message, this.emptyProperties);
    }

    public void warn(String message, Properties properties) {
        this.informationService.inform(this.loggingCategory, 1, message, properties);
    }

    public void warn(String[] categories, String message) {
        this.informationService.inform(this.combineCategories(categories), 1, message, this.emptyProperties);
    }

    public void warn(String[] categories, String message, Properties properties) {
        this.informationService.inform(this.combineCategories(categories), 1, message, properties);
    }

    public void error(String message) {
        this.informationService.inform(this.loggingCategory, 0, message, this.emptyProperties);
    }

    public void error(String message, Properties properties) {
        this.informationService.inform(this.loggingCategory, 0, message, properties);
    }

    public void error(String[] categories, String message) {
        this.informationService.inform(this.combineCategories(categories), 0, message, this.emptyProperties);
    }

    public void error(String[] categories, String message, Properties properties) {
        this.informationService.inform(this.combineCategories(categories), 0, message, properties);
    }

    private String[] combineCategories(String[] categories) {
        String[] totalCategories = new String[categories.length + this.loggingCategory.length];
        System.arraycopy(this.loggingCategory, 0, totalCategories, 0, this.loggingCategory.length);
        System.arraycopy(categories, 0, totalCategories, this.loggingCategory.length, categories.length);
        return totalCategories;
    }
}

