/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.infoserv.core;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.vtp.framework.infoserv.api.Informant;
import org.eclipse.vtp.framework.infoserv.api.InformationService;
import org.eclipse.vtp.framework.infoserv.api.Logger;
import org.eclipse.vtp.framework.infoserv.api.Reporter;
import org.eclipse.vtp.framework.infoserv.core.ChannelRuleSet;
import org.eclipse.vtp.framework.infoserv.core.DefaultInformant;
import org.eclipse.vtp.framework.infoserv.core.DefaultLogger;
import org.eclipse.vtp.framework.infoserv.core.DefaultReporter;
import org.eclipse.vtp.framework.infoserv.spi.InformationChannel;
import org.eclipse.vtp.framework.infoserv.spi.InformationServiceProvider;

public class InformationServiceProviderImpl
implements InformationServiceProvider {
    private volatile ChannelRuleSet[] channelRuleSets = new ChannelRuleSet[0];

    public synchronized void addInformationChannel(InformationChannel informationChannel) {
        ChannelRuleSet[] channels = new ChannelRuleSet[this.channelRuleSets.length + 1];
        System.arraycopy(this.channelRuleSets, 0, channels, 0, this.channelRuleSets.length);
        channels[this.channelRuleSets.length] = new ChannelRuleSet(informationChannel);
        this.channelRuleSets = channels;
    }

    public synchronized void removeInformationChannel(InformationChannel informationChannel) {
        List<ChannelRuleSet> list = Arrays.asList(this.channelRuleSets);
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).getChannel().equals(informationChannel)) {
                list.remove(i);
                break;
            }
            ++i;
        }
        ChannelRuleSet[] channels = new ChannelRuleSet[list.size()];
        int i2 = 0;
        while (i2 < channels.length) {
            channels[i2] = list.get(i2);
            ++i2;
        }
        this.channelRuleSets = channels;
    }

    public Informant createInformant() {
        return new DefaultInformant((InformationService)this);
    }

    public Logger createLogger() {
        return new DefaultLogger((InformationService)this);
    }

    public Reporter createReporter() {
        return new DefaultReporter((InformationService)this);
    }

    public void inform(String[] categories, int severity, String message, Properties properties) {
        ChannelRuleSet[] channels = this.channelRuleSets;
        int i = 0;
        while (i < channels.length) {
            channels[i].inform(categories, severity, message, properties);
            ++i;
        }
    }
}

