/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class RemoveBookmarkAction
extends BookmarkAction {
    public RemoveBookmarkAction(BookmarkNavigator view) {
        super(view, BookmarkMessages.RemoveBookmark_text);
        this.setToolTipText(BookmarkMessages.RemoveBookmark_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.remove_bookmark_action_context");
        this.setEnabled(false);
    }

    public void run() {
        final IStructuredSelection sel = this.getStructuredSelection();
        if (sel.isEmpty()) {
            return;
        }
        try {
            this.getView().getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    Iterator iter = sel.iterator();
                    while (iter.hasNext()) {
                        Object o = iter.next();
                        if (!(o instanceof IMarker)) continue;
                        IMarker marker = (IMarker)o;
                        marker.delete();
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getView().getShell(), (String)BookmarkMessages.RemoveBookmark_errorTitle, null, (IStatus)e.getStatus());
        }
    }

    public void selectionChanged(IStructuredSelection sel) {
        this.setEnabled(!sel.isEmpty());
    }
}

