/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.vtp.desktop.core.localdata.ILocalDomain;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroupVersion;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalDomain;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalLanguagePack;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalModule;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalModuleGroup;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalModuleGroupVersion;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalVendor;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IPersonaProject;
import org.eclipse.vtp.desktop.core.project.event.ObjectRefreshEvent;
import org.eclipse.vtp.desktop.core.project.internals.ApplicationProject;
import org.eclipse.vtp.desktop.core.project.internals.PersonaProject;
import org.eclipse.vtp.desktop.core.project.internals.event.ObjectEvent;
import org.eclipse.vtp.desktop.core.project.internals.event.ObjectListener;
import org.eclipse.vtp.framework.util.Guid;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class DesktopCorePlugin
extends Plugin
implements BundleListener {
    private static DesktopCorePlugin plugin;
    public static String configTemplate;
    public static String applicationTemplate;
    public static String buildPathTemplate;
    public static String bindingTemplate;
    public static String brandPromptsTemplate;
    public static String personaPromptsTemplate;
    public static String fileTextTemplate;
    public static HashMap projectMap;
    private ResourceBundle resourceBundle;
    private BundleContext context = null;
    private Map objectListeners = new HashMap();
    private Map deferredObjects = new HashMap();
    private List eventBuffer = new LinkedList();
    private Map languagePacks = Collections.synchronizedMap(new HashMap());
    private Map vendors = Collections.synchronizedMap(new HashMap());
    private Map axisJars = Collections.synchronizedMap(new HashMap());
    private boolean running = true;

    static {
        configTemplate = "<persona id=\"[id]\" name=\"[name]\" domain=\"[domain]\" language=\"[language]\" language-pack=\"[language-pack-id]\"></persona>";
        applicationTemplate = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><application-design>\t<elements>\t\t<app-start instance-id=\"7ebe546393c240ccaf26c0b1f8fc5d61\" name=\"Start\"/>\t</elements>\t<destinations>\t</destinations>\t<ui-pages>\t\t<ui-page name='main'>\t\t\t<elements>\t\t\t\t<ui-element instance-id=\"7ebe546393c240ccaf26c0b1f8fc5d61\" x=\"50\" y=\"25\"/>\t\t\t</elements>\t\t\t<connectors>\t\t\t</connectors>\t\t</ui-page>\t</ui-pages></application-design>";
        buildPathTemplate = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><application-properties domain=\"[domain]\" id=\"[id]\" name=\"[name]\" version=\"[version]\">\t<shared-libraries></shared-libraries>\t<language-support></language-support></application-properties>";
        bindingTemplate = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><binding:descriptor xmlns:binding=\"http://eclipse.org/vtp/xsd/openVXML/media/binding#1.0\"/>";
        brandPromptsTemplate = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><library:descriptor xmlns:library=\"http://eclipse.org/vtp/xsd/openVXML/media/library#1.0\"/>";
        personaPromptsTemplate = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><persona:descriptor xmlns:persona=\"http://eclipse.org/vtp/xsd/openVXML/media/persona#1.0\"/>";
        fileTextTemplate = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><files:descriptor xmlns:files=\"http://eclipse.org/vtp/xsd/openVXML/media/files#1.0\"/>";
        projectMap = new HashMap();
    }

    public DesktopCorePlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.vtp.desktop.core.ProvisioningCorePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.context = context;
        this.languagePacks.clear();
        Bundle[] bundles = context.getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].getState() != 1) {
                this.bundleInstalled(bundles[i]);
            }
            ++i;
        }
        context.addBundleListener((BundleListener)this);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (DesktopCorePlugin.this.running) {
                    List list = DesktopCorePlugin.this.eventBuffer;
                    synchronized (list) {
                        if (!DesktopCorePlugin.this.eventBuffer.isEmpty()) {
                            Object obj;
                            ObjectEvent oe = (ObjectEvent)DesktopCorePlugin.this.eventBuffer.remove(0);
                            if (DesktopCorePlugin.this.deferredObjects.get(oe.getObjectId()) == null && (obj = DesktopCorePlugin.this.objectListeners.get(oe.getObjectId())) != null) {
                                List ls = (List)obj;
                                WeakReference[] refs = ls.toArray(new WeakReference[0]);
                                int i = 0;
                                while (i < refs.length) {
                                    Object refo = refs[i].get();
                                    if (refo != null) {
                                        ObjectListener l = (ObjectListener)refo;
                                        l.processObjectEvent(oe);
                                    } else {
                                        ls.remove(refs[i]);
                                    }
                                    ++i;
                                }
                            }
                        } else {
                            try {
                                DesktopCorePlugin.this.eventBuffer.wait();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        }).start();
    }

    private File getBundleComponent(Bundle bundle, String entry) {
        String installPath = this.context.getProperty("osgi.install.area");
        if (installPath.toLowerCase().startsWith("file://")) {
            installPath = installPath.substring("file://".length());
        } else if (installPath.toLowerCase().startsWith("file:")) {
            installPath = installPath.substring("file:".length());
        }
        File installFile = new File(installPath);
        if (!installFile.exists() || !installFile.isDirectory()) {
            return null;
        }
        String locationPath = bundle.getLocation();
        if (!locationPath.startsWith("update@")) {
            return null;
        }
        File locationFile = new File(installFile, locationPath.substring("update@".length()));
        if (!locationFile.exists() || !locationFile.isDirectory()) {
            return null;
        }
        File componentFile = new File(locationFile, entry);
        if (!componentFile.exists()) {
            return null;
        }
        return componentFile;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void bundleInstalled(Bundle bundle) {
        if ("org.apache.axis".equals(bundle.getSymbolicName())) {
            this.axisJars.put("axis.jar", this.getBundleComponent(bundle, "lib/axis.jar"));
            this.axisJars.put("commons-discovery.jar", this.getBundleComponent(bundle, "lib/commons-discovery-0.2.jar"));
            this.axisJars.put("commons-logging.jar", this.getBundleComponent(bundle, "lib/commons-logging-1.0.4.jar"));
            this.axisJars.put("jaxrpc.jar", this.getBundleComponent(bundle, "lib/jaxrpc.jar"));
            this.axisJars.put("saaj.jar", this.getBundleComponent(bundle, "lib/saaj.jar"));
            this.axisJars.put("wsdl4j.jar", this.getBundleComponent(bundle, "lib/wsdl4j-1.5.1.jar"));
            return;
        }
        Long id = new Long(bundle.getBundleId());
        URL url = bundle.getEntry("META-INF/openVXML/language.xml");
        if (!this.languagePacks.containsKey(id) && url != null) {
            this.languagePacks.put(id, new LocalLanguagePack(bundle.getSymbolicName(), bundle.getSymbolicName().substring(bundle.getSymbolicName().lastIndexOf(46) + 1), url));
        }
        url = bundle.getEntry("META-INF/openVXML/vendor.xml");
        if (this.vendors.containsKey(id)) return;
        if (url == null) return;
        try {
            Document doc;
            DocumentBuilder builder;
            InputStream input;
            block22: {
                input = null;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                builder = factory.newDocumentBuilder();
                doc = null;
                try {
                    input = url.openStream();
                    doc = builder.parse(new InputSource(input));
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (input != null) {
                        input.close();
                    }
                    input = null;
                    throw throwable;
                }
                {
                    Object var8_12 = null;
                    if (input == null) break block22;
                }
                input.close();
            }
            input = null;
            String name = this.getContent(doc.getDocumentElement(), "info-block/name");
            if (name == null) {
                name = bundle.getSymbolicName().substring(bundle.getSymbolicName().lastIndexOf(46) + 1);
            }
            LocalVendor vendor = new LocalVendor(bundle.getSymbolicName(), name);
            String[] modGroups = this.getContents(doc.getDocumentElement(), "module-groups/module-group");
            if (modGroups != null) {
                int i = 0;
                while (i < modGroups.length) {
                    url = bundle.getEntry("META-INF/openVXML/" + modGroups[i] + ".xml");
                    if (url != null) {
                        block23: {
                            Object var12_15;
                            try {
                                input = url.openStream();
                                doc = builder.parse(new InputSource(input));
                            }
                            catch (Throwable throwable) {
                                var12_15 = null;
                                if (input != null) {
                                    input.close();
                                }
                                input = null;
                                throw throwable;
                            }
                            {
                                var12_15 = null;
                                if (input == null) break block23;
                            }
                            input.close();
                        }
                        input = null;
                        name = this.getContent(doc.getDocumentElement(), "info-block/name");
                        if (name == null) {
                            name = modGroups[i];
                        }
                        LocalModuleGroup group = new LocalModuleGroup(String.valueOf(vendor.getId()) + ":" + modGroups[i], name);
                        Element[] versions = this.getElements(doc.getDocumentElement(), "versions/version");
                        int j = 0;
                        block9: while (true) {
                            if (j >= versions.length) {
                                vendor.addModuleGroup(group);
                                break;
                            }
                            String number = versions[j].getAttribute("number");
                            LocalModuleGroupVersion version = new LocalModuleGroupVersion(String.valueOf(group.getId()) + ":" + number, number, bundle);
                            String[] modules = this.getContents(versions[j], "modules/module");
                            int k = 0;
                            while (true) {
                                if (k >= modules.length) {
                                    group.addVersion(version);
                                    ++j;
                                    continue block9;
                                }
                                url = bundle.getEntry("META-INF/openVXML/" + modules[k] + "_" + number + ".xml");
                                if (url != null) {
                                    version.addModule(new LocalModule(String.valueOf(version.getId()) + ":" + modules[k], modules[k], url));
                                }
                                ++k;
                            }
                            break;
                        }
                    }
                    ++i;
                }
            }
            this.vendors.put(id, vendor);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Element[] getElements(Element element, String path) {
        String token = null;
        StringTokenizer i = new StringTokenizer(path, "/");
        while (i.hasMoreTokens()) {
            token = i.nextToken();
            if (!i.hasMoreTokens()) continue;
            NodeList list = element.getElementsByTagName(token);
            if (list.getLength() == 0) {
                return null;
            }
            element = (Element)list.item(0);
        }
        NodeList list = element.getElementsByTagName(token);
        if (list.getLength() == 0) {
            return null;
        }
        ArrayList<Node> elements = new ArrayList<Node>(list.getLength());
        int i2 = 0;
        while (i2 < list.getLength()) {
            if (((Element)list.item(i2)).getParentNode() == element) {
                elements.add(list.item(i2));
            }
            ++i2;
        }
        return elements.isEmpty() ? null : elements.toArray(new Element[elements.size()]);
    }

    private String getContent(Element element, String path) {
        String[] contents = this.getContents(element, path);
        if (contents == null) {
            return null;
        }
        return contents[0];
    }

    private String[] getContents(Element element, String path) {
        Element[] elements = this.getElements(element, path);
        if (elements == null) {
            return null;
        }
        String[] contents = new String[elements.length];
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            NodeList list = elements[i].getChildNodes();
            int j = 0;
            while (j < list.getLength()) {
                if (list.item(j) instanceof Text) {
                    buf.append(((Text)list.item(j)).getData());
                }
                ++j;
            }
            contents[i] = buf.toString();
            buf.setLength(0);
            ++i;
        }
        return contents;
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                this.bundleInstalled(event.getBundle());
                break;
            }
            case 8: {
                this.uninstallBundle(event.getBundle());
                this.bundleInstalled(event.getBundle());
                break;
            }
            case 16: {
                this.uninstallBundle(event.getBundle());
            }
        }
    }

    private void uninstallBundle(Bundle bundle) {
        if ("org.apche.axis".equals(bundle.getSymbolicName())) {
            this.axisJars.clear();
            return;
        }
        Long id = new Long(bundle.getBundleId());
        this.languagePacks.remove(id);
        this.vendors.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        this.running = false;
        List list = this.eventBuffer;
        synchronized (list) {
            this.eventBuffer.notifyAll();
        }
        context.removeBundleListener((BundleListener)this);
        this.languagePacks.clear();
        this.vendors.clear();
        this.context = null;
        super.stop(context);
    }

    public static DesktopCorePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = DesktopCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void initializeApplicationStructure(IProject newProject, String domainId, String name) throws CoreException {
        IFile callFlow = newProject.getFile("CallDesign.xml");
        callFlow.create((InputStream)new ByteArrayInputStream(applicationTemplate.getBytes()), true, null);
        IFolder brands = newProject.getFolder("Brands");
        brands.create(true, true, null);
        DesktopCorePlugin.initializeBrandStructure(brands, "Default");
        IFolder businessObjects = newProject.getFolder("Business Objects");
        businessObjects.create(true, true, null);
        IFolder databases = newProject.getFolder("Databases");
        databases.create(true, true, null);
        IFolder webServices = newProject.getFolder("Web Services");
        webServices.create(true, true, null);
        IFile buildPath = newProject.getFile(".buildPath");
        String buf = new String(buildPathTemplate);
        buf = buf.replaceAll("\\[id\\]", Guid.createGUID());
        buf = buf.replaceAll("\\[name\\]", name);
        buf = buf.replaceAll("\\[version\\]", "0.0.0.0");
        buf = buf.replaceAll("\\[domain\\]", domainId);
        buildPath.create((InputStream)new ByteArrayInputStream(buf.getBytes()), true, null);
    }

    public static void initializeBrandStructure(IFolder brandsFolder, String brandName) throws CoreException {
        IFolder brand = brandsFolder.getFolder(brandName);
        if (brand.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.vtp.desktop.core", 1, "Brand already exists", null));
        }
        brand.create(true, true, null);
        DesktopCorePlugin.initializeMediaStructure(brand);
    }

    public static void initializeMediaStructure(IFolder mediaRoot) throws CoreException {
        IFile prompts = mediaRoot.getFile("Prompts.xml");
        prompts.create((InputStream)new ByteArrayInputStream(brandPromptsTemplate.getBytes()), true, null);
        IFile binding = mediaRoot.getFile(".binding");
        binding.create((InputStream)new ByteArrayInputStream(bindingTemplate.getBytes()), true, null);
        IFolder filesFolder = mediaRoot.getFolder("Media Files");
        filesFolder.create(true, true, null);
        IFile fileText = filesFolder.getFile(".audioFiles");
        fileText.create((InputStream)new ByteArrayInputStream(fileTextTemplate.getBytes()), true, null);
    }

    public static void initializeMediaStructure(IProject mediaRoot) throws CoreException {
        IFile prompts = mediaRoot.getFile("Prompts.xml");
        prompts.create((InputStream)new ByteArrayInputStream(personaPromptsTemplate.getBytes()), true, null);
        IFolder filesFolder = mediaRoot.getFolder("Media Files");
        filesFolder.create(true, true, null);
        IFile fileText = filesFolder.getFile(".audioFiles");
        fileText.create((InputStream)new ByteArrayInputStream(fileTextTemplate.getBytes()), true, null);
    }

    public static void initializePersonaStructure(IProject newProject, String name, String domainId, String language, String languagePackId) throws CoreException {
        DesktopCorePlugin.initializeMediaStructure(newProject);
        IFile config = newProject.getFile(".config");
        String buf = new String(configTemplate);
        buf = buf.replaceAll("\\[id\\]", Guid.createGUID());
        buf = buf.replaceAll("\\[name\\]", name);
        buf = buf.replaceAll("\\[domain\\]", domainId);
        buf = buf.replaceAll("\\[language\\]", language);
        buf = buf.replaceAll("\\[language-pack-id\\]", languagePackId);
        config.create((InputStream)new ByteArrayInputStream(buf.toString().getBytes()), true, null);
    }

    public static IApplicationProject convertToApplication(IProject project) throws CoreException {
        if (project.getDescription().hasNature("org.eclipse.vtp.desktop.core.VoiceApplicationNature")) {
            return new ApplicationProject(project);
        }
        return null;
    }

    public static IPersonaProject convertToPersona(IProject project) throws CoreException {
        if (project.getDescription().hasNature("org.eclipse.vtp.desktop.core.VoicePersonaNature")) {
            return new PersonaProject(project);
        }
        return null;
    }

    public Map getAxisJars() {
        return new HashMap(this.axisJars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObjectListener(String objectId, ObjectListener l) {
        List list = this.eventBuffer;
        synchronized (list) {
            Object obj = this.objectListeners.get(objectId);
            if (obj == null) {
                obj = new ArrayList();
                this.objectListeners.put(objectId, obj);
            }
            ArrayList ls = (ArrayList)obj;
            WeakReference[] refs = ls.toArray(new WeakReference[0]);
            int i = 0;
            while (i < refs.length) {
                if (refs[i].get() == null) {
                    ls.remove(refs[i]);
                } else if (refs[i].get() == l) {
                    ls.remove(refs[i]);
                    break;
                }
                ++i;
            }
            ls.add(new WeakReference<ObjectListener>(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObjectListener(String objectId, ObjectListener l) {
        List list = this.eventBuffer;
        synchronized (list) {
            Object obj = this.objectListeners.get(objectId);
            if (obj == null) {
                obj = new ArrayList();
                this.objectListeners.put(objectId, obj);
            }
            ArrayList ls = (ArrayList)obj;
            WeakReference[] refs = ls.toArray(new WeakReference[0]);
            int i = 0;
            while (i < refs.length) {
                if (refs[i].get() == null) {
                    ls.remove(refs[i]);
                } else if (refs[i].get() == l) {
                    ls.remove(refs[i]);
                    break;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postObjectEvent(ObjectEvent event) {
        List list = this.eventBuffer;
        synchronized (list) {
            this.eventBuffer.add(event);
            this.eventBuffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferEvents(String objectId) {
        List list = this.eventBuffer;
        synchronized (list) {
            this.deferredObjects.put(objectId, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeEvents(String objectId) {
        List list = this.eventBuffer;
        synchronized (list) {
            this.deferredObjects.remove(objectId);
            this.postObjectEvent(new ObjectRefreshEvent(objectId));
        }
    }

    public static boolean isApplicationProject(IProject project) {
        try {
            return project.getNature("org.eclipse.vtp.desktop.core.VoiceApplicationNature") != null;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isPersonaProject(IProject project) {
        try {
            return project.getNature("org.eclipse.vtp.desktop.core.VoicePersonaNature") != null;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public ILocalDomain getLocalDomain() {
        LocalDomain domain = new LocalDomain("", "");
        LocalVendor vendor = new LocalVendor("", "");
        Iterator i = this.languagePacks.values().iterator();
        while (i.hasNext()) {
            vendor.addLanguagePack((LocalLanguagePack)i.next());
        }
        domain.addVendor(vendor);
        i = this.vendors.values().iterator();
        while (i.hasNext()) {
            LocalVendor next = (LocalVendor)i.next();
            vendor = (LocalVendor)domain.getVendorByName(next.getName());
            if (vendor == null || !vendor.getId().equals(next.getId())) {
                domain.addVendor(next);
                continue;
            }
            Iterator j = next.getModuleGroups().iterator();
            while (j.hasNext()) {
                LocalModuleGroup next2 = (LocalModuleGroup)j.next();
                LocalModuleGroup group = (LocalModuleGroup)vendor.getModuleGroupByName(next2.getName());
                if (group == null || !group.getId().equals(next2.getId())) {
                    vendor.addModuleGroup(next2);
                    continue;
                }
                Iterator k = next2.getVersions().iterator();
                while (k.hasNext()) {
                    LocalModuleGroupVersion next3 = (LocalModuleGroupVersion)k.next();
                    ILocalModuleGroupVersion ver = group.getVersionByNumber(next3.getVersionNumber());
                    if (ver != null && ver.getId().equals(next3.getId())) continue;
                    group.addVersion(next3);
                }
            }
        }
        return domain;
    }
}

