/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.localdata.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vtp.desktop.core.localdata.ILocalDomain;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroup;
import org.eclipse.vtp.desktop.core.localdata.ILocalVendor;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalDomain;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalLanguagePack;
import org.eclipse.vtp.desktop.core.localdata.internals.LocalModuleGroup;

public class LocalVendor
implements ILocalVendor {
    private String id;
    private String name;
    private List moduleGroups;
    private List languagePacks;
    private LocalDomain domain;

    public LocalVendor(String id, String name) {
        this.id = id;
        this.name = name;
        this.moduleGroups = new ArrayList();
        this.languagePacks = new ArrayList();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void addLanguagePack(LocalLanguagePack languagePack) {
        this.languagePacks.add(languagePack);
        languagePack.setVendor(this);
    }

    public List getLanguagePacks() {
        return Collections.unmodifiableList(this.languagePacks);
    }

    public void addModuleGroup(LocalModuleGroup moduleGroup) {
        this.moduleGroups.add(moduleGroup);
        moduleGroup.setVendor(this);
    }

    public ILocalModuleGroup getModuleGroupByName(String moduleGroupName) {
        Iterator i = this.moduleGroups.iterator();
        while (i.hasNext()) {
            LocalModuleGroup lv = (LocalModuleGroup)i.next();
            if (!lv.getName().equalsIgnoreCase(moduleGroupName)) continue;
            return lv;
        }
        return null;
    }

    public List getModuleGroups() {
        return Collections.unmodifiableList(this.moduleGroups);
    }

    public ILocalDomain getDomain() {
        return this.domain;
    }

    protected void setDomain(LocalDomain domain) {
        this.domain = domain;
    }
}

