/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project.internals;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.project.IApplicationDesign;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IBrandSet;
import org.eclipse.vtp.desktop.core.project.IBusinessObjectSet;
import org.eclipse.vtp.desktop.core.project.IDatabaseSet;
import org.eclipse.vtp.desktop.core.project.IPersonaProject;
import org.eclipse.vtp.desktop.core.project.IVoiceProject;
import org.eclipse.vtp.desktop.core.project.IWebServiceSet;
import org.eclipse.vtp.desktop.core.project.event.ReloadObjectDataEvent;
import org.eclipse.vtp.desktop.core.project.internals.ApplicationDesign;
import org.eclipse.vtp.desktop.core.project.internals.BrandSet;
import org.eclipse.vtp.desktop.core.project.internals.BusinessObjectSet;
import org.eclipse.vtp.desktop.core.project.internals.DatabaseSet;
import org.eclipse.vtp.desktop.core.project.internals.SupportedLanguage;
import org.eclipse.vtp.desktop.core.project.internals.VoiceProject;
import org.eclipse.vtp.desktop.core.project.internals.WebServiceSet;
import org.eclipse.vtp.desktop.core.project.internals.event.ObjectEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ApplicationProject
extends VoiceProject
implements IApplicationProject {
    private static final String DEFAULT_FRAMEWORK_VERSION = "2.1";
    private String applicationId;
    private String applicationName;
    private String applicationVersion;
    private String applicationFrameworkVersion;
    private String domainId;
    private List supportedLanguages = new ArrayList();
    private WebServiceSet webServiceSet = null;

    public ApplicationProject(IProject project) {
        super(project);
        this.loadBuildPath();
    }

    public IVoiceProject getProject() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBuildPath() {
        this.supportedLanguages.clear();
        ApplicationProject applicationProject = this;
        synchronized (applicationProject) {
            try {
                IFile buildPath = this.project.getFile(".buildPath");
                DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = buildFactory.newDocumentBuilder();
                Document doc = builder.parse(buildPath.getContents());
                Element root = doc.getDocumentElement();
                this.applicationId = root.getAttribute("id");
                this.applicationName = root.getAttribute("name");
                this.applicationVersion = root.getAttribute("version");
                this.applicationFrameworkVersion = root.getAttribute("framework-version");
                if (this.applicationFrameworkVersion == null || this.applicationFrameworkVersion.length() == 0) {
                    this.applicationFrameworkVersion = DEFAULT_FRAMEWORK_VERSION;
                }
                this.domainId = root.getAttribute("domain");
                IProject[] projs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                NodeList nl = root.getElementsByTagName("language-support");
                if (nl.getLength() < 1) {
                    throw new RuntimeException("language-support element missing in build path");
                }
                Element personasElement = (Element)nl.item(0);
                nl = personasElement.getElementsByTagName("language");
                int i = 0;
                while (i < nl.getLength()) {
                    Element languageElement = (Element)nl.item(i);
                    String localeCode = languageElement.getAttribute("locale");
                    String languageCode = "";
                    String countryCode = "";
                    String variantCode = "";
                    String[] parts = localeCode.split("-");
                    languageCode = parts[0];
                    if (parts.length > 1) {
                        countryCode = parts[1];
                    }
                    if (parts.length > 2) {
                        variantCode = parts[2];
                    }
                    Locale locale = new Locale(languageCode, countryCode, variantCode);
                    IPersonaProject persona = null;
                    String personaId = languageElement.getAttribute("persona");
                    int p = 0;
                    while (p < projs.length) {
                        if (projs[p].hasNature("org.eclipse.vtp.desktop.core.VoicePersonaNature")) {
                            IPersonaProject pp = DesktopCorePlugin.convertToPersona(projs[p]);
                            if (pp.getPersonaId().equals(personaId)) {
                                persona = pp;
                                break;
                            }
                            persona = null;
                        }
                        ++p;
                    }
                    SupportedLanguage sl = new SupportedLanguage(locale, persona);
                    this.supportedLanguages.add(sl);
                    ++i;
                }
            }
            catch (FactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getApplicationFrameworkVersion() {
        return this.applicationFrameworkVersion;
    }

    public IApplicationDesign getApplicationDesign() {
        IFile f = this.project.getFile("CallDesign.xml");
        if (!f.exists()) {
            throw new RuntimeException("Missing desing document");
        }
        return new ApplicationDesign(f, this);
    }

    public IBrandSet getBrandSet() {
        IFolder f = this.project.getFolder("Brands");
        if (!f.exists()) {
            throw new RuntimeException("Missing brands folder");
        }
        return new BrandSet(this, f);
    }

    public void processObjectEvent(ObjectEvent event) {
        if (event instanceof ReloadObjectDataEvent) {
            this.loadBuildPath();
            this.refresh();
        }
        super.processObjectEvent(event);
    }

    public List getSupportedLanguages() {
        return Collections.unmodifiableList(this.supportedLanguages);
    }

    public void setApplicationVersion(String version) {
        this.applicationVersion = version;
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = document.createElement("application-properties");
            document.appendChild(rootElement);
            rootElement.setAttribute("id", this.applicationId);
            rootElement.setAttribute("name", this.applicationName);
            rootElement.setAttribute("version", this.applicationVersion);
            rootElement.setAttribute("domain", this.domainId);
            Element languageSupportElement = document.createElement("language-support");
            rootElement.appendChild(languageSupportElement);
            Iterator iterator = this.supportedLanguages.iterator();
            while (iterator.hasNext()) {
                SupportedLanguage sl = (SupportedLanguage)iterator.next();
                Element languageElement = document.createElement("language");
                languageSupportElement.appendChild(languageElement);
                String languageCode = sl.getLocale().getLanguage();
                if (!sl.getLocale().getCountry().equals("")) {
                    languageCode = String.valueOf(languageCode) + "-" + sl.getLocale().getCountry();
                    if (!sl.getLocale().getVariant().equals("")) {
                        languageCode = String.valueOf(languageCode) + "-" + sl.getLocale().getVariant();
                    }
                }
                languageElement.setAttribute("locale", languageCode);
                languageElement.setAttribute("persona", sl.getSupportingPersona() == null ? "" : sl.getSupportingPersona().getPersonaId());
            }
            Element sharedLibrariesElement = document.createElement("shared-libraries");
            rootElement.appendChild(sharedLibrariesElement);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            trans.transform(source, result);
            IFile buildPath = this.project.getFile(".buildPath");
            buildPath.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        DesktopCorePlugin.getDefault().postObjectEvent(new ReloadObjectDataEvent(this.getObjectId()));
    }

    public void setSupportedLanguages(List languages) {
        this.supportedLanguages = languages;
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = document.createElement("application-properties");
            document.appendChild(rootElement);
            rootElement.setAttribute("id", this.applicationId);
            rootElement.setAttribute("name", this.applicationName);
            rootElement.setAttribute("version", this.applicationVersion);
            rootElement.setAttribute("domain", this.domainId);
            Element languageSupportElement = document.createElement("language-support");
            rootElement.appendChild(languageSupportElement);
            Iterator iterator = this.supportedLanguages.iterator();
            while (iterator.hasNext()) {
                SupportedLanguage sl = (SupportedLanguage)iterator.next();
                Element languageElement = document.createElement("language");
                languageSupportElement.appendChild(languageElement);
                String languageCode = sl.getLocale().getLanguage();
                if (!sl.getLocale().getCountry().equals("")) {
                    languageCode = String.valueOf(languageCode) + "-" + sl.getLocale().getCountry();
                    if (!sl.getLocale().getVariant().equals("")) {
                        languageCode = String.valueOf(languageCode) + "-" + sl.getLocale().getVariant();
                    }
                }
                languageElement.setAttribute("locale", languageCode);
                languageElement.setAttribute("persona", sl.getSupportingPersona() == null ? "" : sl.getSupportingPersona().getPersonaId());
            }
            Element sharedLibrariesElement = document.createElement("shared-libraries");
            rootElement.appendChild(sharedLibrariesElement);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            trans.transform(source, result);
            IFile buildPath = this.project.getFile(".buildPath");
            buildPath.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        DesktopCorePlugin.getDefault().postObjectEvent(new ReloadObjectDataEvent(this.getObjectId()));
    }

    public IBusinessObjectSet getBusinessObjectSet() {
        IFolder f = this.project.getFolder("Business Objects");
        if (!f.exists()) {
            throw new RuntimeException("Missing business objects folder");
        }
        return new BusinessObjectSet(this, f);
    }

    public IDatabaseSet getDatabaseSet() {
        IFolder f = this.project.getFolder("Databases");
        if (!f.exists()) {
            throw new RuntimeException("Missing databases folder");
        }
        return new DatabaseSet(this, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWebServiceSet getWebServiceSet() {
        ApplicationProject applicationProject = this;
        synchronized (applicationProject) {
            if (this.webServiceSet == null) {
                IFolder f = this.project.getFolder("Web Services");
                if (!f.exists()) {
                    throw new RuntimeException("Missing web services folder");
                }
                this.webServiceSet = new WebServiceSet(this, f);
            }
            return this.webServiceSet;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApplicationProject)) {
            return false;
        }
        return ((ApplicationProject)obj).project.equals((Object)this.project);
    }
}

