/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project.internals;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.core.project.IPersonaProject;
import org.eclipse.vtp.desktop.core.project.IPromptSet;
import org.eclipse.vtp.desktop.core.project.internals.MediaFilesFolder;
import org.eclipse.vtp.desktop.core.project.internals.PromptSet;
import org.eclipse.vtp.desktop.core.project.internals.VoiceProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PersonaProject
extends VoiceProject
implements IPersonaProject {
    public PersonaProject(IProject project) {
        super(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPersonaName() throws CoreException {
        String ret = null;
        PersonaProject personaProject = this;
        synchronized (personaProject) {
            try {
                IFile buildPath = this.project.getFile(".config");
                DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = buildFactory.newDocumentBuilder();
                Document doc = builder.parse(buildPath.getContents());
                Element root = doc.getDocumentElement();
                ret = root.getAttribute("name");
            }
            catch (FactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public void setPersonaName() throws CoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPersonaId() throws CoreException {
        String ret = null;
        PersonaProject personaProject = this;
        synchronized (personaProject) {
            try {
                IFile buildPath = this.project.getFile(".config");
                DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = buildFactory.newDocumentBuilder();
                if (!buildPath.isSynchronized(2)) {
                    buildPath.refreshLocal(2, null);
                }
                Document doc = builder.parse(buildPath.getContents());
                Element root = doc.getDocumentElement();
                ret = root.getAttribute("id");
            }
            catch (FactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLanguagePackId() throws CoreException {
        String ret = null;
        PersonaProject personaProject = this;
        synchronized (personaProject) {
            try {
                IFile buildPath = this.project.getFile(".config");
                DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = buildFactory.newDocumentBuilder();
                Document doc = builder.parse(buildPath.getContents());
                Element root = doc.getDocumentElement();
                ret = root.getAttribute("language-pack");
            }
            catch (FactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLanguageCode() throws CoreException {
        String ret = null;
        PersonaProject personaProject = this;
        synchronized (personaProject) {
            try {
                IFile buildPath = this.project.getFile(".config");
                DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = buildFactory.newDocumentBuilder();
                Document doc = builder.parse(buildPath.getContents());
                Element root = doc.getDocumentElement();
                ret = root.getAttribute("language");
            }
            catch (FactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public IPromptSet getPromptSet() {
        return new PromptSet(this.project.getFile("Prompts.xml"), this);
    }

    public IMediaFilesFolder getMediaFilesFolder() {
        IFolder f = this.project.getFolder("Media Files");
        if (!f.exists()) {
            throw new RuntimeException("Media Files is missing");
        }
        return new MediaFilesFolder(this, f);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPersonaProject) {
            IPersonaProject pp = (IPersonaProject)obj;
            try {
                if (pp.getPersonaId().equals(this.getPersonaId())) {
                    return true;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return super.equals(obj);
    }
}

