/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project.internals;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.core.project.IVoiceProject;
import org.eclipse.vtp.desktop.core.project.IVoiceResource;
import org.eclipse.vtp.desktop.core.project.internals.VoiceResource;

public abstract class VoiceProject
extends VoiceResource
implements IVoiceProject {
    IProject project;
    static /* synthetic */ Class class$0;

    public VoiceProject(IProject project) {
        this.project = project;
        this.activateEvents();
    }

    public String getName() {
        return this.project.getName();
    }

    public IVoiceResource getParent() {
        return null;
    }

    public IProject getUnderlyingProject() {
        return this.project;
    }

    protected String getObjectId() {
        return this.project.getFullPath().toPortableString();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this.project;
        }
        return super.getAdapter(adapter);
    }

    public File archiveProject() {
        File ret = null;
        try {
            IFile projzip;
            IFolder buildFolder = this.project.getFolder(".build");
            if (!buildFolder.exists()) {
                buildFolder.create(true, true, null);
            }
            if (!(projzip = buildFolder.getFile("project.zip")).exists()) {
                projzip.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            }
            ret = projzip.getLocation().toFile();
            FileOutputStream fos = new FileOutputStream(ret);
            ZipOutputStream zos = new ZipOutputStream(fos);
            IResource[] resources = this.project.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i].exists() && !resources[i].getName().equals(".build")) {
                    if (resources[i] instanceof IFolder) {
                        zos.putNextEntry(new ZipEntry(String.valueOf(resources[i].getProjectRelativePath().toString()) + "/"));
                        this.writeChildren(zos, (IFolder)resources[i]);
                    } else {
                        zos.putNextEntry(new ZipEntry(resources[i].getProjectRelativePath().toString()));
                        FileInputStream fis = new FileInputStream(resources[i].getLocation().toFile());
                        byte[] buf = new byte[10240];
                        int len = fis.read(buf);
                        while (len != -1) {
                            zos.write(buf, 0, len);
                            len = fis.read(buf);
                        }
                        fis.close();
                    }
                }
                ++i;
            }
            zos.close();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private void writeChildren(ZipOutputStream zos, IFolder folder) throws IOException, CoreException {
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            if (resources[i].exists()) {
                if (resources[i] instanceof IFolder) {
                    zos.putNextEntry(new ZipEntry(String.valueOf(resources[i].getProjectRelativePath().toString()) + "/"));
                    this.writeChildren(zos, (IFolder)resources[i]);
                } else {
                    zos.putNextEntry(new ZipEntry(resources[i].getProjectRelativePath().toString()));
                    FileInputStream fis = new FileInputStream(resources[i].getLocation().toFile());
                    byte[] buf = new byte[10240];
                    int len = fis.read(buf);
                    while (len != -1) {
                        zos.write(buf, 0, len);
                        len = fis.read(buf);
                    }
                    fis.close();
                }
            }
            ++i;
        }
    }
}

