/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project.internals;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.project.IVoiceProject;
import org.eclipse.vtp.desktop.core.project.IVoiceResource;
import org.eclipse.vtp.desktop.core.project.event.IRefreshListener;
import org.eclipse.vtp.desktop.core.project.event.ObjectRefreshEvent;
import org.eclipse.vtp.desktop.core.project.internals.event.ObjectEvent;
import org.eclipse.vtp.desktop.core.project.internals.event.ObjectListener;

public abstract class VoiceResource
implements IVoiceResource,
ObjectListener {
    List refreshListeners = new ArrayList();

    public IVoiceProject getProject() {
        if (this instanceof IVoiceProject) {
            return (IVoiceProject)((Object)this);
        }
        IVoiceResource parent = this.getParent();
        while (!(parent instanceof IVoiceProject)) {
            parent = parent.getParent();
        }
        return (IVoiceProject)parent;
    }

    void activateEvents() {
        DesktopCorePlugin.getDefault().registerObjectListener(this.getObjectId(), this);
    }

    protected void finalize() throws Throwable {
        DesktopCorePlugin.getDefault().unregisterObjectListener(this.getObjectId(), this);
        super.finalize();
    }

    protected abstract String getObjectId();

    public void deferEvents() {
        DesktopCorePlugin.getDefault().deferEvents(this.getObjectId());
    }

    public void resumeEvents() {
        DesktopCorePlugin.getDefault().resumeEvents(this.getObjectId());
    }

    public void addRefreshListener(IRefreshListener l) {
        this.refreshListeners.remove(l);
        this.refreshListeners.add(l);
    }

    public void removeRefreshListener(IRefreshListener l) {
        this.refreshListeners.remove(l);
    }

    public void processObjectEvent(ObjectEvent event) {
        if (event instanceof ObjectRefreshEvent) {
            IRefreshListener[] ls = this.refreshListeners.toArray(new IRefreshListener[0]);
            int i = 0;
            while (i < ls.length) {
                ls[i].refreshResource(this);
                ++i;
            }
        }
    }

    public void refresh() {
        DesktopCorePlugin.getDefault().postObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

