/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.extensions.internal.drop;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.DDLGenerator;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOption;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputViewAPI;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.drop.IDropSQLObject;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;
import org.eclipse.wst.rdb.server.internal.ui.query.execute.QueryOutputHelper;

public class DropObject {
    protected SQLObject mysqlObj = null;

    public DropObject(SQLObject theSQLObj) {
        this.mysqlObj = theSQLObj;
    }

    public void run(ConnectionInfo conInfo) {
        IDropSQLObject dropSQLObject = null;
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.server.extensions", "DropSQLObjects");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String objectType;
                if (configElements[j].getName().equals("DropProvider") && (objectType = configElements[j].getAttribute("objectClassname")).equals(this.mysqlObj.getClass().getName())) {
                    try {
                        dropSQLObject = (IDropSQLObject)configElements[j].createExecutableExtension("class");
                        break;
                    }
                    catch (CoreException e) {
                        ServerExtensionsPlugin.getDefault().writeLog(4, 0, e.getMessage(), e);
                    }
                }
                ++j;
            }
            if (dropSQLObject != null) break;
            ++i;
        }
        if (dropSQLObject == null) {
            DropObject.dropSQLObject(this.mysqlObj, Utility.getSchemaQualifiedName(this.mysqlObj), conInfo);
        } else {
            dropSQLObject.dropSQLObject(this.mysqlObj);
        }
    }

    public static boolean dropSQLObject(SQLObject sqlObject, String qualifiedName, ConnectionInfo conInfo) {
        boolean dropResult = true;
        try {
            OutputViewAPI outputView = OutputViewAPI.getInstance();
            OutputItem outItem = outputView.findOutputItem(qualifiedName, 33);
            if (outItem == null) {
                outItem = new OutputItem(1, 33, Utility.getSchemaQualifiedName(sqlObject), qualifiedName);
            } else {
                outputView.resetOutputItem(outItem, true);
            }
            outputView.addOutputItem(outItem, true);
            OutputViewAPI.getInstance().showMessage(outItem, ServerExtensionsPlugin.getString("DROP_STARTED", new Object[]{qualifiedName}), true);
            DDLGenerator ddlProvider = conInfo.getDatabaseDefinition().getDDLGenerator();
            SQLObject[] elements = new SQLObject[]{sqlObject};
            EngineeringOption[] options = ddlProvider.getOptions(elements);
            ArrayList<Boolean> optionsSettings = new ArrayList<Boolean>(options.length);
            int i = 0;
            while (i < options.length) {
                EngineeringOption option = options[i];
                if (option != null) {
                    optionsSettings.add(i, new Boolean(option.getBoolean()));
                    option.setBoolean(true);
                } else {
                    optionsSettings.add(null);
                }
                ++i;
            }
            String[] dropObjects = ddlProvider.dropSQLObjects(elements, true, true, (IProgressMonitor)new NullProgressMonitor());
            int i2 = 0;
            while (i2 < options.length) {
                EngineeringOption option = options[i2];
                if (option != null) {
                    option.setBoolean(((Boolean)optionsSettings.get(i2)).booleanValue());
                }
                ++i2;
            }
            QueryOutputHelper outputHelper = new QueryOutputHelper(conInfo.getSharedConnection());
            outputHelper.setOutputItem(outItem);
            outputHelper.setUpdateOutputItemStatus(false);
            boolean warningMsg = false;
            if (dropObjects.length == 0) {
                dropResult = false;
            } else {
                int i3 = 0;
                while (i3 < dropObjects.length) {
                    outputHelper.setStatement(dropObjects[i3]);
                    boolean executeResult = outputHelper.executeDDL(ServerExtensionsPlugin.getString("DDL_GEN", new Object[]{Utility.getSchemaQualifiedName(sqlObject)}));
                    if (!warningMsg && !executeResult) {
                        warningMsg = true;
                    }
                    if (i3 == dropObjects.length - 1 && !executeResult) {
                        dropResult = false;
                    }
                    ++i3;
                }
            }
            if (dropResult && !warningMsg) {
                OutputViewAPI.getInstance().updateStatus(outItem, 2, true);
                OutputViewAPI.getInstance().showMessage(outItem, ServerExtensionsPlugin.getString("DROP_COMPLETED", new Object[]{qualifiedName}), true);
            } else if (dropResult && warningMsg) {
                OutputViewAPI.getInstance().updateStatus(outItem, 3, true);
                OutputViewAPI.getInstance().showMessage(outItem, ServerExtensionsPlugin.getString("DROP_COMPLETED_WITH_WARNINGS", new Object[]{qualifiedName}), true);
            } else {
                OutputViewAPI.getInstance().updateStatus(outItem, 4, true);
                OutputViewAPI.getInstance().showMessage(outItem, ServerExtensionsPlugin.getString("DROP_FAILED", new Object[]{qualifiedName}), true);
            }
        }
        catch (Exception e) {
            ServerExtensionsPlugin.getDefault().writeLog(4, 0, e.getMessage(), e);
            dropResult = false;
        }
        return dropResult;
    }
}

