/*******************************************************************************
 * Copyright (c) 2006 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/

package org.eclipse.vtp.launching.internal.tellme;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;

/**
 * @author mgreenawalt
 * 
 */
public class GetLogListChange implements Runnable {
	final static int WAIT_SECS = 30;

	final private static SimpleDateFormat time = new SimpleDateFormat(
			"mm:ss.SSS", Locale.getDefault()); //$NON-NLS-1$

	final private static boolean DEBUGGING = TellmePlugin.getDefault()
			.isDebugging();

	public void run() {
		CallState.initLogList();

		final String logList0 = StudioInteractions.getFirstLogFromList(StudioInteractions.getListOfLogs()).getSessionID();
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e1) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR, //$NON-NLS-1$
					Messages.GetLogListChange_0, e1));
		}
		String logList = null;
		CallLog log = null;
		int waitLoops = WAIT_SECS / 2;
		while ((logList = (log = StudioInteractions.getFirstLogFromList(StudioInteractions.getListOfLogs())).getSessionID()) != null
				&& logList.equals(logList0) && waitLoops-- != 0 && !CallState.isStopping()) {
			if (DEBUGGING) {
				System.out.println(time.format(new Date())
						+ ": Check for log flow start again."); //$NON-NLS-1$
				System.out.flush();
			}
			try {
				Thread.sleep(2000);
			} catch (InterruptedException e) {
				DebugPlugin.log(new Status(IStatus.ERROR,
						"org.eclipse.vtp.launching.tellme", IStatus.ERROR, //$NON-NLS-1$
						Messages.GetLogListChange_1, e));
			}
		}
		if (CallState.isStopping()) {
			CallState.reportLogListFail(Messages.GetLogListChange_2);
			CallState.reportLogFetchFail(""); //$NON-NLS-1$
			synchronized (CallState.getSynch()) {
				CallState.setLogListDone();
				CallState.setLogFetchDone();
				if (CallState.launchDone()){
					CallState.endLaunch();
				}
			}
			return;
		}
		if (waitLoops <= 0) {
			if (DEBUGGING) {
				System.out
						.println("waited too long for log to start streaming"); //$NON-NLS-1$
				System.out.flush();
			}
			CallState.reportLogListFail(Messages.GetLogListChange_4 + WAIT_SECS
					+ Messages.GetLogListChange_5);
			CallState.setLog(null);

		} else {
			CallState.setLog(log);
			CallState.reportLogListSucceed(""); //$NON-NLS-1$
		}
		synchronized (CallState.getSynch()) {
			CallState.setLogListDone();
		}
		new GetLogItems().run();
		return;
	}

}
