/*******************************************************************************
 * Copyright (c) 2005, 2006 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/
package org.eclipse.vtp.launching.internal.tellme;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.TrustManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.vtp.launching.internal.tellme.CallLog;
import org.eclipse.vtp.launching.internal.tellme.LogItemReader;
import org.eclipse.vtp.launching.internal.tellme.TellmeBrowserException;

/**
 * 
 * 
 * @author mgreenawalt
 * @author rjray
 */
public class StudioInteractions {
	// studioURL is path to the studio platform. attached
	protected final static String studioURLpath = "https://studio.tellme.com/mystudio/mystudio.pl"; //$NON-NLS-1$

	protected final static String studioLogListURL = "https://studio.tellme.com/mystudio/loglist.pl"; //$NON-NLS-1$

	protected final static String studioViewLogURL = "https://studio.tellme.com/mystudio/viewlog.pl"; //$NON-NLS-1$

	private final static boolean DEBUGGING = TellmePlugin.getDefault()
			.isDebugging();

	final private static SimpleDateFormat time = new SimpleDateFormat(
			"mm:ss.SSS", Locale.getDefault()); //$NON-NLS-1$

	public static void studioScratchpadMode() {
		consumeStudioTransaction(studioURLpath, loginString
				+ "&newmode=2", Messages.StudioInteractions_4); //$NON-NLS-1$
	}

	public static void sendApplicationURL(final String appURL) {
		try {
			final String studioURLquery = loginString
					+ "&srv_url_staging=" //$NON-NLS-1$
					+ URLEncoder.encode(appURL, "UTF-8"); //$NON-NLS-1$
			consumeStudioTransaction(studioURLpath, studioURLquery,
					Messages.StudioInteractions_13);
		} catch (UnsupportedEncodingException e2) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR, //$NON-NLS-1$
					Messages.StudioInteractions_15, e2));
		}
	}

	public static StringBuffer getListOfLogs() {
		return captureStudioTransaction(studioLogListURL, loginString,
				Messages.StudioInteractions_16);
	}

	public static CallLog getFirstLogFromList(final StringBuffer logList) {
		int startOfViewRef = -1;
		int endOfViewRef = -1;

		startOfViewRef = logList.indexOf("viewlog.pl?sessionid="); //$NON-NLS-1$
		if (startOfViewRef == -1) {
			return new CallLog("", "");
		}
		endOfViewRef = logList.indexOf("\"", startOfViewRef); //$NON-NLS-1$
		int callIDRef = logList.indexOf("<td ", endOfViewRef); //$NON-NLS-1$
		callIDRef = logList.indexOf("<td ", callIDRef + 4); //$NON-NLS-1$
		final int endcallIDRef = logList.indexOf("<", callIDRef + 4); //$NON-NLS-1$
		final String callID = logList.substring(callIDRef + 16, endcallIDRef);
		// at this point, startOfViewRef and endOfViewRef determine the log
		// reference
		final String viewlog = logList.substring(startOfViewRef, endOfViewRef);
		final String[] parts = viewlog.split("\\?"); //$NON-NLS-1$
		if (DEBUGGING) {
			System.out.println(time.format(new Date())
					+ ": StudioInteractions.getFirstLogFromList called: "+viewlog); //$NON-NLS-1$
			System.out.flush();
		}

		return new CallLog(callID, loginString + "&" + parts[1]); //$NON-NLS-1$
	}

	public static StringBuffer getTheLog(final CallLog theLog) {
		return (theLog == null) ? new StringBuffer()
				: captureStudioTransaction(studioViewLogURL, theLog
						.getSessionID(), Messages.StudioInteractions_28);
	}

	public static LogItemReader getLogItemReader(final CallLog theLog)
			throws TellmeBrowserException {
		URL transactionURL = null;
		final String urlQuery = theLog.getSessionID();
		String errormsg = Messages.StudioInteractions_29;
		try {
			transactionURL = new URL(studioViewLogURL+"?eclipsemark"); //$NON-NLS-1$
		} catch (MalformedURLException e1) {
			throw new TellmeBrowserException(e1.getMessage());
		}
		/* sun.net.www.protocol.http. */HttpURLConnection connection;
		try { 

			final SSLContext sslCon = SSLContext.getInstance("SSL"); //$NON-NLS-1$
			sslCon.init(null, trustAllCerts, new java.security.SecureRandom());
			HttpsURLConnection.setDefaultSSLSocketFactory(sslCon
					.getSocketFactory());

			connection = (/* sun.net.www.protocol.http. */HttpURLConnection) transactionURL
					.openConnection();
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setRequestMethod("POST"); //$NON-NLS-1$
			connection.setUseCaches(false);
			connection.setRequestProperty("Content-type", //$NON-NLS-1$
					"application/x-www-form-urlencoded"); //$NON-NLS-1$
			connection.setRequestProperty("Content-length", "" //$NON-NLS-1$ //$NON-NLS-2$
					+ urlQuery.length());

			// send the post data
			final OutputStreamWriter writer = new OutputStreamWriter(connection
					.getOutputStream());
			writer.write(urlQuery);
			writer.flush();
			writer.close();
			final int studioresponse = connection.getResponseCode();
			if (studioresponse != HttpURLConnection.HTTP_OK) {
				final String err = errormsg + connection.getResponseMessage();
				DisplayActions.showError(Messages.StudioInteractions_36,
						err);

				throw new TellmeBrowserException(err);
			}

			return new LogItemReader(connection.getInputStream());
		} catch (IOException e) {
			errormsg = e.getMessage();
		} catch (NoSuchAlgorithmException e) {
			errormsg = e.getMessage();
		} catch (KeyManagementException e) {
			errormsg = e.getMessage();
		}

		throw new TellmeBrowserException(errormsg);

	}

	// **************************************************************************************
	public void consumeResponsePage(final URLConnection connection) {
		handleResponsePage(connection, false);
	}

	public StringBuffer captureResponsePage(final URLConnection connection) {
		return handleResponsePage(connection, true);
	}

	private static StringBuffer handleResponsePage(
			final URLConnection connection, final boolean keepPage) {
		BufferedReader contentStream;
		final StringWriter contentStore = new StringWriter();

		try {
			contentStream = new BufferedReader(new InputStreamReader(connection
					.getInputStream()));
			// contentStore will wind up containing the html text
			final PrintWriter contentWriter = new PrintWriter(contentStore);

			String line = contentStream.readLine();
			while (line != null) {
				if (keepPage) {
					contentWriter.println(line);
				}
				line = contentStream.readLine();
			}
		} catch (IOException e) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR, //$NON-NLS-1$
					Messages.StudioInteractions_38, e));
		}

		return contentStore.getBuffer();
	}

	public static void consumeStudioTransaction(final String urlPath,
			final String urlQuery, final String errmsg) {
		handleStudioTransaction(urlPath, urlQuery, false, errmsg);
	}

	public static StringBuffer captureStudioTransaction(final String urlPath,
			final String urlQuery, final String errmsg) {
		return handleStudioTransaction(urlPath, urlQuery, true, errmsg);
	}

	// Create a trust manager that does not validate certificate chains
	static private TrustManager[] trustAllCerts = new TrustManager[] { new X509TrustManager() {
		public java.security.cert.X509Certificate[] getAcceptedIssuers() {
			return null;
		}

		public void checkClientTrusted(
				final java.security.cert.X509Certificate[] certs,
				final String authType) {
		}

		public void checkServerTrusted(
				final java.security.cert.X509Certificate[] certs,
				final String authType) {
		}
	} };

	// Install the all-trusting trust manager

	protected static StringBuffer handleStudioTransaction(final String urlPath,
			final String urlQuery, final boolean capturePage,
			final String errormsg) {
		URL transactionURL = null;
		try {
			transactionURL = new URL(urlPath+"?eclipsemark"); //$NON-NLS-1$
		} catch (MalformedURLException e1) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR, //$NON-NLS-1$
					Messages.StudioInteractions_40, e1));
		}
		/* sun.net.www.protocol.http. */HttpURLConnection connection;
		try { 

			final SSLContext sslCon = SSLContext.getInstance("SSL"); //$NON-NLS-1$
			sslCon.init(null, trustAllCerts, new java.security.SecureRandom());
			HttpsURLConnection.setDefaultSSLSocketFactory(sslCon
					.getSocketFactory());

			connection = (/* sun.net.www.protocol.http. */HttpURLConnection) transactionURL
					.openConnection();
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setRequestMethod("POST"); //$NON-NLS-1$
			connection.setUseCaches(false);
			connection.setRequestProperty("Content-type", //$NON-NLS-1$
					"application/x-www-form-urlencoded"); //$NON-NLS-1$
			connection.setRequestProperty("Content-length", "" //$NON-NLS-1$ //$NON-NLS-2$
					+ urlQuery.length());

			// send the post data
			final OutputStreamWriter writer = new OutputStreamWriter(connection
					.getOutputStream());
			writer.write(urlQuery);
			writer.flush();
			writer.close();
			final int studioresponse = connection.getResponseCode();
			if (studioresponse != HttpURLConnection.HTTP_OK) {
				final String err = errormsg + connection.getResponseMessage();
				DisplayActions.showError(Messages.StudioInteractions_47,
						err);

				return null;
			}

			return handleResponsePage(connection, capturePage);
		} catch (IOException e) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR, //$NON-NLS-1$
					Messages.StudioInteractions_49, e));
		} catch (NoSuchAlgorithmException e) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR, //$NON-NLS-1$
					Messages.StudioInteractions_51, e));
		} catch (KeyManagementException e) {
			DebugPlugin.log(new Status(IStatus.ERROR,
					"org.eclipse.vtp.launching.tellme", IStatus.ERROR, //$NON-NLS-1$
					Messages.StudioInteractions_53, e));
		}

		return null;
	}

	protected static void setLogin(final String loginstring) {
		loginString = loginstring;
	}

	private static String loginString = ""; //$NON-NLS-1$

}
