package org.eclipse.vtp.editor.srgxml.ui.internal.wizards;
/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.vtp.catalog.registry.CatalogEntry;
import org.eclipse.vtp.editor.internal.wizards.NewFileContentGenerator;
import org.eclipse.vtp.editor.srgxml.ui.internal.Logger;


/**
 * Default generic content generator for the various new file wizards
 * Configured from plugin.xml manifest's &lt;newfile&gt; element, and
 * optional subclasses can be defined there in the generatorClass attribute
 * 
 * @author Frank Sauer
 */
public class NewSRGXMLFileContentGenerator extends NewFileContentGenerator{

	/**
	 * XML indent (3 spaces)
	 */
	protected static final String INDENT = "   "; //$NON-NLS-1$


	/**
	 * constructor
	 * @param dtd the vocabulary to use
	 */
	public NewSRGXMLFileContentGenerator(CatalogEntry dtd) {
		super(dtd);
	}
	
	
	

	/**
	 * Add in the Rule if one was specified
	 */

	GrammarRulePage grammarRulePage;
	
	public void addAdditionalAttributes2(PrintWriter p) {
		grammarRulePage = NewXMLWizard.getGrammarRulePage();
		try {
			writeRules(p);
		} catch (Throwable e) {
			Logger.logException("Error while writing rules:", e); //$NON-NLS-1$
		}
	}
	public void writeRules(PrintWriter p) throws IOException {
		String ruleName = grammarRulePage.getRuleName();
		String strWords = grammarRulePage.getWordList();
		String fileName = grammarRulePage.getFileName();
		String root = grammarRulePage.rootRule;
		if (root != null) 
		{
			List words = new ArrayList();
			if (strWords != null && strWords.length() > 0) {
				StringTokenizer t = new StringTokenizer(strWords, "\n\r"); //$NON-NLS-1$
				while (t.hasMoreTokens()) {
					String next = t.nextToken().trim();
					if (next.length() > 0) {
						words.add(next);
					}
				}
			} else if (fileName != null && fileName.length() > 0) {
				readWordsFromFile(words, fileName);
			}
			if (words.size() > 0) {
				writeRule(p, ruleName, words);
			}
		}	
	}
	
	private void writeRule(PrintWriter p, String ruleName, List words) {
		indent(p);
		p.print("<rule id=\""); //$NON-NLS-1$
		p.print(ruleName);
		p.println("\" scope=\"public\">"); //$NON-NLS-1$
		indent(p);
		indent(p);
		p.println("<one-of>"); //$NON-NLS-1$
		for (Iterator i = words.iterator(); i.hasNext();) {
			indent(p);
			indent(p);
			indent(p);
			p.print("<item>"); //$NON-NLS-1$
			p.print(i.next());
			p.println("</item>"); //$NON-NLS-1$
		}
		indent(p);
		indent(p);
		p.println("</one-of>"); //$NON-NLS-1$
		indent(p);
		p.println("</rule>"); //$NON-NLS-1$
	}

	private void readWordsFromFile(List words, String fileName) throws IOException {
		FileInputStream fIn = null;
		try {
			File file = new File(fileName);
			fIn = new FileInputStream(file);
			InputStreamReader in = new InputStreamReader (fIn);
			BufferedReader buffin = new BufferedReader (in);
			String readbuff;
			do { 						
				readbuff = 	buffin.readLine ();						
				if (readbuff != null) {
					String next = readbuff.trim();
					if (next.length() > 0) {
						words.add (next);
					}
				}
			}	while (readbuff != null);
		} finally {
			if (fIn != null) {
				fIn.close();
			}
		}
	}

	/**
	 * prints the INDENT string to p
	 * @param p output goes here
	 */
	protected void indent(PrintWriter p) {
		p.print(INDENT); //$NON-NLS-1$
	}	


	


	
	

	

}

