package org.eclipse.vtp.editor.srgxml.ui.internal.wizards;
/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.vtp.catalog.registry.CatalogDefaultResolver;
import org.eclipse.vtp.catalog.registry.CatalogEntry;
import org.eclipse.vtp.editor.internal.wizards.NewXMLGenerator;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.ui.internal.wizards.XMLSchemaValidationChecker;
import org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages;


public class NewSRGXMLGenerator extends NewXMLGenerator {

	protected String grammarURI;
	protected CMDocument cmDocument;
	protected int buildPolicy;
	protected String rootElementName;

	protected ICatalogEntry xmlCatalogEntry;

	// info for dtd
	protected String publicId;
	protected String systemId;
	protected String defaultSystemId;

	// info for xsd
	public List namespaceInfoList;

	public NewSRGXMLGenerator() {
		super();
	}

	public NewSRGXMLGenerator(String grammarURI, CMDocument cmDocument) {
		this.grammarURI = grammarURI;
		this.cmDocument = cmDocument;
	}


	public static CMDocument createCMDocument(String uri, String[] errorInfo) {
		String title = null;
		String message = null;
		List errorList = new Vector();
		CMDocument cmDocument = null;

		if (URIHelper.isReadableURI(uri, true)) {
			uri = URIHelper.normalize(uri, null, null);
			cmDocument = ContentModelManager.getInstance().createCMDocument(uri, null);

			if (uri.endsWith(".dtd")) { //$NON-NLS-1$
				if (errorList.size() > 0) {
					title = XMLWizardsMessages._UI_INVALID_GRAMMAR_ERROR;
					message = XMLWizardsMessages._UI_LABEL_ERROR_DTD_INVALID_INFO;
				}
			}
			else // ".xsd"
			{
				// To be consistent with the schema editor validation
				XMLSchemaValidationChecker validator = new XMLSchemaValidationChecker();
				if (!validator.isValid(uri)) {
					title = XMLWizardsMessages._UI_INVALID_GRAMMAR_ERROR;
					message = XMLWizardsMessages._UI_LABEL_ERROR_SCHEMA_INVALID_INFO;
				}
				else if (cmDocument != null) {
					int globalElementCount = cmDocument.getElements().getLength();
					if (globalElementCount == 0) {
						title = XMLWizardsMessages._UI_WARNING_TITLE_NO_ROOT_ELEMENTS;
						message = XMLWizardsMessages._UI_WARNING_MSG_NO_ROOT_ELEMENTS;
					}
				}
			}
		}
		else {
			title = XMLWizardsMessages._UI_WARNING_TITLE_NO_ROOT_ELEMENTS;
			message = XMLWizardsMessages._UI_WARNING_URI_NOT_FOUND_COLON + " " + uri; //$NON-NLS-1$
		}
		errorInfo[0] = title;
		errorInfo[1] = message;

		return cmDocument;
	}

// CN - Added method to write Special file based on Language (root element is passed on)
	public void createDefaultXMLDocument(IFile newFile, String xmlFileName, String rootElementName, String contentType) throws Exception {
// 	 CN - get Default entry for the content Type
		CatalogEntry dtd = CatalogDefaultResolver.getDefaultEntryForContentType(contentType);
       publicId = dtd.getKey();
		if (dtd.getWebURL() != null)
			systemId = dtd.getWebURL();
		else
			systemId = dtd.getURI();			

		String charset = getUserPreferredCharset();
		if (charset == null) {
			charset = "UTF-8"; //$NON-NLS-1$			}
		}		
		ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		String charSet = getUserPreferredCharset();

		PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream, charSet));

		NewSRGXMLFileContentGenerator generator = new NewSRGXMLFileContentGenerator(dtd);
		writer.println(generator.getNewFileContent(false, rootElementName, contentType)); //$NON-NLS-1$

		writer.flush();
		outputStream.close();

		ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
		newFile.setContents(inputStream, true, true, null);
		inputStream.close();		

	}		

	
}
