/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Jens Lukowski/Innoopract - initial renaming/restructuring
 *     
 *******************************************************************************/
package org.eclipse.vtp.editor.ccxml.ui.internal;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistry;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistryImpl;


/**
 * The main plugin class to be used in the desktop.
 */
public class CCXMLUIPlugin extends AbstractUIPlugin {
	public final static String ID = "org.eclipse.vtp.editor.ccxml.ui"; //$NON-NLS-1$

	protected static CCXMLUIPlugin instance = null;
	

	public static CCXMLUIPlugin getDefault() {
		return instance;
	}

	public synchronized static CCXMLUIPlugin getInstance() {
		return instance;
	}


	public CCXMLUIPlugin() {
		super();
		instance = this;
	}

	public AdapterFactoryRegistry getAdapterFactoryRegistry() {
		return AdapterFactoryRegistryImpl.getInstance();

	}

	/**
	   * Get an image from the registry. 
	   * 
	   * *This method is used by the referencingfile dialog and should be 
	   *  removed when the dialog is moved to anothercomponent.
	   * 
	   * @param imageName The name of the image.
	   * @return The image registered for the given name.
	   */
	public Image getImage(String imageName){
	    return getWorkbench().getSharedImages().getImage(imageName);
	}
}
