/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/
package org.eclipse.vtp.editor.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * The main plugin class to be used in the desktop.
 */
public class VoicetoolsEditorPlugin extends AbstractUIPlugin {
	
	/**
	 * plugin ID
	 */
	public static final String ID = "org.eclipse.vtp.editor"; //$NON-NLS-1$

	private static VoicetoolsEditorPlugin instance = null;

	/**
	 * constructor
	 */
	public VoicetoolsEditorPlugin() {
		instance = this;
	}
	
	/**
	 * @return singleton
	 */
	public static synchronized VoicetoolsEditorPlugin getDefault() {
		return instance;
	}
	
	/**
	 * get image with given name
	 * @param iconName name
	 * @return image
	 */
	public Image getImage(String iconName) {
	  ImageRegistry imageRegistry = getImageRegistry();
    
	  if (imageRegistry.get(iconName) != null) {
		return imageRegistry.get(iconName);
	  } else {
		imageRegistry.put(iconName, ImageDescriptor.createFromFile(getClass(), iconName));
		return imageRegistry.get(iconName);
	  }
	}	
	
	/**
	 * Get the XML plugin preferences
	 * @return preferences
	 */
	//public static Preferences getXMLModelPreferences() {
	//	return XMLCorePlugin.getDefault().getPluginPreferences();
	//}

	/**
	 * Get the preferrde encoding from the xml preferences
	 * @return XML encoding set in XML preferences
	 */
//	public static String getPreferredEncoding() {
//		return getXMLModelPreferences().getString(CommonEncodingPreferenceNames.OUTPUT_CODESET);
//		return VoiceToolkitPlugin.getDefault().getCurrentEncoding();
//	}
}