/*******************************************************************************
 * Copyright (c) 2005 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/
package org.eclipse.vtp.launching.internal.tellme;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/**
 *
 *
 * @author rjray
 * @author mgreenawalt
 */
public class DisplayActions {

    final private static SimpleDateFormat time =
        new SimpleDateFormat("mm:ss.SSS", Locale.getDefault()); //$NON-NLS-1$

    private final static boolean DEBUGGING =
        TellmePlugin.getDefault().isDebugging();

    private static Display theDisplay = null;

    private DisplayActions() {
        super();
    }

    private static Display findDisplay() {
        if (theDisplay == null) {
            theDisplay = Display.getDefault();
        }
        return theDisplay;
    }

    /**
     * showError is called to display a message dialog with the reason for a
     * failed call
     *
     * @param failReason
     *            a String with the failure result returned from the Skype
     *            client
     */
    public static void showError(final String title, final String failReason) {
        final String foo = title;
        final String bar = failReason;
        final Display display = findDisplay();
        if (DEBUGGING) {
            System.out.println(time.format(new Date()) +
                    Messages.DisplayActions_1+failReason);
            System.out.flush();
        }
        display.asyncExec(new Runnable() {

            public void run() {
                MessageDialog.openError(new Shell(display, SWT.NONE), foo, bar);
            }
        });
    }

    public static void showError(final String failReason) {
        showError(Messages.DisplayActions_2, failReason);
    }

    /**
     * showEndOfCall is called when the entire "call" is complete. The Studio phone 
     * interaction is done, and the log fetching is done.
     * 
     * @param theCallID
     * 		contains the id number assigned to the Studio session by Studio
     */
    public static void showEndOfCall(final String theCallID) {
        final Display display = findDisplay();
        if (DEBUGGING) {
            System.out.println(time.format(new Date()) +
                    Messages.DisplayActions_3);
            System.out.flush();
        }

        display.asyncExec(new Runnable() {
            public void run() {
                final String msgID = "".equals(theCallID) ? Messages.DisplayActions_0 //$NON-NLS-1$
                    : theCallID;
                MessageDialog.openInformation(new Shell(display, SWT.NONE),
                    Messages.DisplayActions_6, Messages.DisplayActions_7 + msgID + Messages.DisplayActions_8);
            }
        });
    }


}
