/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;

public class SWTGraphics
extends Graphics {
    static final int AA_MASK;
    static final int AA_SHIFT;
    static final int CAP_MASK;
    static final int CAP_SHIFT;
    static final int FILL_RULE_MASK;
    static final int FILL_RULE_SHIFT;
    static final int INTERPOLATION_MASK;
    static final int INTERPOLATION_SHIFT;
    static final int JOIN_MASK;
    static final int JOIN_SHIFT;
    static final int LINE_STYLE_MASK;
    static final int TEXT_AA_MASK;
    static final int TEXT_AA_SHIFT;
    static final int XOR_MASK;
    static final int XOR_SHIFT;
    static final int ADVANCED_MASK;
    static final int ADVANCED_SHIFT;
    private final LazyState appliedState = new LazyState();
    private final State currentState = new State();
    private boolean elementsNeedUpdate;
    private GC gc;
    private boolean sharedClipping;
    private List stack = new ArrayList();
    private int stackPointer = 0;
    Transform transform;
    private int translateX = 0;
    private int translateY = 0;

    static {
        XOR_SHIFT = 3;
        CAP_SHIFT = 4;
        JOIN_SHIFT = 6;
        AA_SHIFT = 8;
        TEXT_AA_SHIFT = 10;
        INTERPOLATION_SHIFT = 12;
        FILL_RULE_SHIFT = 14;
        ADVANCED_SHIFT = 15;
        LINE_STYLE_MASK = 7;
        AA_MASK = 3 << AA_SHIFT;
        CAP_MASK = 3 << CAP_SHIFT;
        FILL_RULE_MASK = 1 << FILL_RULE_SHIFT;
        INTERPOLATION_MASK = 3 << INTERPOLATION_SHIFT;
        JOIN_MASK = 3 << JOIN_SHIFT;
        TEXT_AA_MASK = 3 << TEXT_AA_SHIFT;
        XOR_MASK = 1 << XOR_SHIFT;
        ADVANCED_MASK = 1 << ADVANCED_SHIFT;
    }

    public SWTGraphics(GC gc) {
        this.gc = gc;
        this.init();
    }

    protected final void checkFill() {
        if (!this.appliedState.bgColor.equals((Object)this.currentState.bgColor)) {
            this.appliedState.bgColor = this.currentState.bgColor;
            this.gc.setBackground(this.appliedState.bgColor);
        }
        this.checkGC();
    }

    protected final void checkGC() {
        if (this.appliedState.relativeClip != this.currentState.relativeClip) {
            this.appliedState.relativeClip = this.currentState.relativeClip;
            this.currentState.relativeClip.setOn(this.gc, this.translateX, this.translateY);
        }
        if (this.appliedState.graphicHints != this.currentState.graphicHints) {
            this.reconcileHints(this.appliedState.graphicHints, this.currentState.graphicHints);
            this.appliedState.graphicHints = this.currentState.graphicHints;
        }
    }

    protected final void checkPaint() {
        this.checkGC();
        if (!this.appliedState.fgColor.equals((Object)this.currentState.fgColor)) {
            this.appliedState.fgColor = this.currentState.fgColor;
            this.gc.setForeground(this.appliedState.fgColor);
        }
        if (this.appliedState.lineWidth != this.currentState.lineWidth) {
            this.appliedState.lineWidth = this.currentState.lineWidth;
            this.gc.setLineWidth(this.appliedState.lineWidth);
        }
        if (!this.appliedState.bgColor.equals((Object)this.currentState.bgColor)) {
            this.appliedState.bgColor = this.currentState.bgColor;
            this.gc.setBackground(this.appliedState.bgColor);
        }
    }

    protected final void checkText() {
        this.checkPaint();
        if (!this.appliedState.font.equals((Object)this.currentState.font)) {
            this.appliedState.font = this.currentState.font;
            this.gc.setFont(this.appliedState.font);
        }
    }

    public void clipRect(Rectangle rect) {
        if (this.currentState.relativeClip == null) {
            throw new IllegalStateException("The current clipping area does not support intersection.");
        }
        this.checkSharedClipping();
        this.currentState.relativeClip.intersect(rect.x, rect.y, rect.right(), rect.bottom());
        this.appliedState.relativeClip = null;
    }

    public void dispose() {
        while (this.stackPointer > 0) {
            this.popState();
        }
        if (this.transform != null) {
            this.transform.dispose();
        }
    }

    public void drawArc(int x, int y, int width, int height, int offset, int length) {
        this.checkPaint();
        this.gc.drawArc(x + this.translateX, y + this.translateY, width, height, offset, length);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.checkPaint();
        this.gc.drawFocus(x + this.translateX, y + this.translateY, w + 1, h + 1);
    }

    public void drawImage(Image srcImage, int x, int y) {
        this.checkGC();
        this.gc.drawImage(srcImage, x + this.translateX, y + this.translateY);
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        this.checkGC();
        this.gc.drawImage(srcImage, x1, y1, w1, h1, x2 + this.translateX, y2 + this.translateY, w2, h2);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.checkPaint();
        this.gc.drawLine(x1 + this.translateX, y1 + this.translateY, x2 + this.translateX, y2 + this.translateY);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.checkPaint();
        this.gc.drawOval(x + this.translateX, y + this.translateY, width, height);
    }

    public void drawPath(Path path) {
        this.checkPaint();
        this.initTransform(false);
        this.gc.drawPath(path);
    }

    public void drawPoint(int x, int y) {
        this.checkPaint();
        this.gc.drawPoint(x + this.translateX, y + this.translateY);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawPolygon(int[] points) {
        this.checkPaint();
        try {
            this.translatePointArray(points, this.translateX, this.translateY);
            this.gc.drawPolygon(points);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            return;
        }
    }

    public void drawPolygon(PointList points) {
        this.drawPolygon(points.toIntArray());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawPolyline(int[] points) {
        this.checkPaint();
        try {
            this.translatePointArray(points, this.translateX, this.translateY);
            this.gc.drawPolyline(points);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            return;
        }
    }

    public void drawPolyline(PointList points) {
        this.drawPolyline(points.toIntArray());
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.checkPaint();
        this.gc.drawRectangle(x + this.translateX, y + this.translateY, width, height);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.checkPaint();
        this.gc.drawRoundRectangle(r.x + this.translateX, r.y + this.translateY, r.width, r.height, arcWidth, arcHeight);
    }

    public void drawString(String s, int x, int y) {
        this.checkText();
        this.gc.drawString(s, x + this.translateX, y + this.translateY, true);
    }

    public void drawText(String s, int x, int y) {
        this.checkText();
        this.gc.drawText(s, x + this.translateX, y + this.translateY, true);
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.checkText();
        layout.draw(this.gc, x + this.translateX, y + this.translateY, selectionStart, selectionEnd, selectionForeground, selectionBackground);
    }

    public void fillArc(int x, int y, int width, int height, int offset, int length) {
        this.checkFill();
        this.gc.fillArc(x + this.translateX, y + this.translateY, width, height, offset, length);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.checkPaint();
        this.gc.fillGradientRectangle(x + this.translateX, y + this.translateY, w, h, vertical);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.checkFill();
        this.gc.fillOval(x + this.translateX, y + this.translateY, width, height);
    }

    public void fillPath(Path path) {
        this.checkFill();
        this.initTransform(false);
        this.gc.fillPath(path);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fillPolygon(int[] points) {
        this.checkFill();
        try {
            this.translatePointArray(points, this.translateX, this.translateY);
            this.gc.fillPolygon(points);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            return;
        }
    }

    public void fillPolygon(PointList points) {
        this.fillPolygon(points.toIntArray());
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.checkFill();
        this.gc.fillRectangle(x + this.translateX, y + this.translateY, width, height);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.checkFill();
        this.gc.fillRoundRectangle(r.x + this.translateX, r.y + this.translateY, r.width, r.height, arcWidth, arcHeight);
    }

    public void fillString(String s, int x, int y) {
        this.checkText();
        this.gc.drawString(s, x + this.translateX, y + this.translateY, false);
    }

    public void fillText(String s, int x, int y) {
        this.checkText();
        this.gc.drawText(s, x + this.translateX, y + this.translateY, false);
    }

    public int getAntialias() {
        return ((this.currentState.graphicHints & AA_MASK) >> AA_SHIFT) - 1;
    }

    public Color getBackgroundColor() {
        return this.currentState.bgColor;
    }

    public Rectangle getClip(Rectangle rect) {
        if (this.currentState.relativeClip != null) {
            this.currentState.relativeClip.getBoundingBox(rect);
            return rect;
        }
        throw new IllegalStateException("Clipping can no longer be queried due to transformations");
    }

    public int getFillRule() {
        return ((this.currentState.graphicHints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) + 1;
    }

    public Font getFont() {
        return this.currentState.font;
    }

    public FontMetrics getFontMetrics() {
        this.checkText();
        return this.gc.getFontMetrics();
    }

    public Color getForegroundColor() {
        return this.currentState.fgColor;
    }

    public int getInterpolation() {
        return ((this.currentState.graphicHints & INTERPOLATION_MASK) >> INTERPOLATION_SHIFT) - 1;
    }

    public int getLineCap() {
        return (this.currentState.graphicHints & CAP_MASK) >> CAP_SHIFT;
    }

    public int getLineJoin() {
        return (this.currentState.graphicHints & JOIN_MASK) >> JOIN_SHIFT;
    }

    public int getLineStyle() {
        return this.currentState.graphicHints & LINE_STYLE_MASK;
    }

    public int getLineWidth() {
        return this.currentState.lineWidth;
    }

    public int getTextAntialias() {
        return this.gc.getTextAntialias();
    }

    public boolean getXORMode() {
        return (this.currentState.graphicHints & XOR_MASK) != 0;
    }

    protected void init() {
        this.currentState.bgColor = this.appliedState.bgColor = this.gc.getBackground();
        this.currentState.fgColor = this.appliedState.fgColor = this.gc.getForeground();
        this.currentState.font = this.appliedState.font = this.gc.getFont();
        this.currentState.lineWidth = this.appliedState.lineWidth = this.gc.getLineWidth();
        this.currentState.graphicHints |= this.gc.getLineStyle();
        this.currentState.graphicHints |= this.gc.getLineCap() << CAP_SHIFT;
        this.currentState.graphicHints |= this.gc.getLineJoin() << JOIN_SHIFT;
        if (this.gc.getXORMode()) {
            this.currentState.graphicHints |= XOR_MASK;
        }
        this.appliedState.graphicHints = this.currentState.graphicHints;
        this.currentState.relativeClip = new RectangleClipping(this.gc.getClipping());
        this.currentState.lineDash = this.gc.getLineDash();
        this.currentState.alpha = this.gc.getAlpha();
    }

    private void initTransform(boolean force) {
        if (!force && this.translateX == 0 && this.translateY == 0) {
            return;
        }
        if (this.transform == null) {
            this.transform = new Transform((Device)Display.getCurrent());
            this.elementsNeedUpdate = true;
            this.transform.translate((float)this.translateX, (float)this.translateY);
            this.translateX = 0;
            this.translateY = 0;
            this.gc.setTransform(this.transform);
        }
    }

    public void popState() {
        --this.stackPointer;
        this.restoreState((State)this.stack.get(this.stackPointer));
    }

    public void pushState() {
        if (this.currentState.relativeClip == null) {
            throw new IllegalStateException("The clipping has been modified ina way that cannot be saved and restored.");
        }
        try {
            this.currentState.dx = this.translateX;
            this.currentState.dy = this.translateY;
            if (this.elementsNeedUpdate) {
                this.elementsNeedUpdate = false;
                this.currentState.affineMatrix = new float[6];
                this.transform.getElements(this.currentState.affineMatrix);
            }
            if (this.stack.size() > this.stackPointer) {
                State s = (State)this.stack.get(this.stackPointer);
                s.copyFrom(this.currentState);
            } else {
                this.stack.add(this.currentState.clone());
            }
            this.sharedClipping = true;
            ++this.stackPointer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void reconcileHints(int applied, int hints) {
        if (applied != hints) {
            int changes = hints ^ applied;
            if ((changes & LINE_STYLE_MASK) != 0) {
                this.gc.setLineStyle(hints & LINE_STYLE_MASK);
            }
            if ((changes & XOR_MASK) != 0) {
                this.gc.setXORMode((hints & XOR_MASK) != 0);
            }
            if ((changes &= ~(XOR_MASK | LINE_STYLE_MASK)) == 0) {
                return;
            }
            if ((changes & JOIN_MASK) != 0) {
                this.gc.setLineJoin((hints & JOIN_MASK) >> JOIN_SHIFT);
            }
            if ((changes & CAP_MASK) != 0) {
                this.gc.setLineCap((hints & CAP_MASK) >> CAP_SHIFT);
            }
            if ((changes & INTERPOLATION_MASK) != 0) {
                this.gc.setInterpolation(((hints & INTERPOLATION_MASK) >> INTERPOLATION_SHIFT) - 1);
            }
            if ((changes & FILL_RULE_MASK) != 0) {
                this.gc.setFillRule(((hints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) + 1);
            }
            if ((changes & AA_MASK) != 0) {
                this.gc.setAntialias(((hints & AA_MASK) >> AA_SHIFT) - 1);
            }
            if ((changes & TEXT_AA_MASK) != 0) {
                this.gc.setTextAntialias(((hints & TEXT_AA_MASK) >> TEXT_AA_SHIFT) - 1);
            }
        }
    }

    public void restoreState() {
        this.restoreState((State)this.stack.get(this.stackPointer - 1));
    }

    protected void restoreState(State s) {
        this.setAffineMatrix(s.affineMatrix);
        this.currentState.relativeClip = s.relativeClip;
        this.sharedClipping = true;
        this.setBackgroundColor(s.bgColor);
        this.setBackgroundPattern(s.bgPattern);
        this.setForegroundColor(s.fgColor);
        this.setForegroundPattern(s.fgPattern);
        this.setGraphicHints(s.graphicHints);
        this.setLineWidth(s.lineWidth);
        this.setFont(s.font);
        this.setAlpha(s.alpha);
        this.translateX = this.currentState.dx = s.dx;
        this.translateY = this.currentState.dy = s.dy;
    }

    public void rotate(float degrees) {
        this.checkGC();
        this.initTransform(true);
        this.transform.rotate(degrees);
        this.gc.setTransform(this.transform);
        this.elementsNeedUpdate = true;
        this.currentState.relativeClip = null;
    }

    public void scale(double factor) {
        this.scale((float)factor, (float)factor);
    }

    public void scale(float horizontal, float vertical) {
        this.checkGC();
        this.initTransform(true);
        this.transform.scale(horizontal, vertical);
        this.gc.setTransform(this.transform);
        this.elementsNeedUpdate = true;
        this.checkSharedClipping();
        if (this.currentState.relativeClip != null) {
            this.currentState.relativeClip.scale(horizontal, vertical);
        }
    }

    private void setAffineMatrix(float[] m) {
        if (!this.elementsNeedUpdate && this.currentState.affineMatrix == m) {
            return;
        }
        this.currentState.affineMatrix = m;
        if (m != null) {
            this.transform.setElements(m[0], m[1], m[2], m[3], m[4], m[5]);
        } else if (this.transform != null) {
            this.transform.dispose();
            this.transform = null;
            this.elementsNeedUpdate = false;
        }
        this.gc.setTransform(this.transform);
    }

    public void setAlpha(int alpha) {
        if (this.currentState.alpha != alpha) {
            this.currentState.alpha = alpha;
            this.gc.setAlpha(this.currentState.alpha);
        }
    }

    public void setAntialias(int value) {
        this.currentState.graphicHints &= ~AA_MASK;
        this.currentState.graphicHints |= value + 1 << AA_SHIFT;
    }

    public void setBackgroundColor(Color color) {
        this.currentState.bgColor = color;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.currentState.fgPattern == pattern) {
            return;
        }
        this.currentState.bgPattern = pattern;
        if (pattern != null) {
            this.initTransform(true);
            this.gc.setBackgroundPattern(pattern);
        } else {
            this.gc.setBackground(this.appliedState.bgColor);
        }
    }

    public void setClip(Path path) {
        this.initTransform(false);
        this.gc.setClipping(path);
        this.currentState.relativeClip = null;
    }

    public void setClip(Rectangle rect) {
        this.currentState.relativeClip = new RectangleClipping(rect);
    }

    public void setFillRule(int rule) {
        this.currentState.graphicHints &= ~FILL_RULE_MASK;
        this.currentState.graphicHints |= rule - 1 << FILL_RULE_SHIFT;
    }

    public void setFont(Font f) {
        this.currentState.font = f;
    }

    public void setForegroundColor(Color color) {
        this.currentState.fgColor = color;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.currentState.fgPattern == pattern) {
            return;
        }
        this.currentState.fgPattern = pattern;
        if (pattern != null) {
            this.initTransform(true);
            this.gc.setForegroundPattern(pattern);
        } else {
            this.gc.setForeground(ColorConstants.orange);
            this.gc.setForeground(this.appliedState.fgColor);
        }
    }

    private void setGraphicHints(int hints) {
        this.currentState.graphicHints = hints;
    }

    public void setInterpolation(int interpolation) {
        this.currentState.graphicHints &= ~INTERPOLATION_MASK;
        this.currentState.graphicHints |= interpolation + 1 << INTERPOLATION_SHIFT;
    }

    public void setLineCap(int cap) {
        this.currentState.graphicHints &= ~CAP_MASK;
        this.currentState.graphicHints |= cap << CAP_SHIFT;
    }

    public void setLineDash(int[] dash) {
        this.currentState.lineDash = dash;
        this.gc.setLineDash(dash);
    }

    public void setLineJoin(int join) {
        this.currentState.graphicHints &= ~JOIN_MASK;
        this.currentState.graphicHints |= join << JOIN_SHIFT;
    }

    public void setLineStyle(int style) {
        this.currentState.graphicHints &= ~LINE_STYLE_MASK;
        this.currentState.graphicHints |= style;
    }

    public void setLineWidth(int width) {
        this.currentState.lineWidth = width;
    }

    public void setTextAntialias(int value) {
        this.currentState.graphicHints &= ~TEXT_AA_MASK;
        this.currentState.graphicHints |= value + 1 << TEXT_AA_SHIFT;
    }

    public void setXORMode(boolean xor) {
        this.currentState.graphicHints &= ~XOR_MASK;
        if (xor) {
            this.currentState.graphicHints |= XOR_MASK;
        }
    }

    public void translate(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        if (this.transform != null) {
            this.checkGC();
            this.transform.translate((float)dx, (float)dy);
            this.elementsNeedUpdate = true;
            this.gc.setTransform(this.transform);
        } else {
            this.translateX += dx;
            this.translateY += dy;
        }
        this.checkSharedClipping();
        if (this.currentState.relativeClip != null) {
            this.currentState.relativeClip.translate(-dx, -dy);
        }
    }

    private void checkSharedClipping() {
        if (this.sharedClipping) {
            this.sharedClipping = false;
            boolean previouslyApplied = this.appliedState == this.currentState.relativeClip;
            this.currentState.relativeClip = this.currentState.relativeClip.getCopy();
            if (previouslyApplied) {
                this.appliedState.relativeClip = this.currentState.relativeClip;
            }
        }
    }

    private void translatePointArray(int[] points, int translateX, int translateY) {
        if (translateX == 0 && translateY == 0) {
            return;
        }
        int i = 0;
        while (i + 1 < points.length) {
            int n = i;
            points[n] = points[n] + translateX;
            int n2 = i + 1;
            points[n2] = points[n2] + translateY;
            i += 2;
        }
    }

    static interface Clipping {
        public Rectangle getBoundingBox(Rectangle var1);

        public Clipping getCopy();

        public void intersect(int var1, int var2, int var3, int var4);

        public void scale(float var1, float var2);

        public void setOn(GC var1, int var2, int var3);

        public void translate(float var1, float var2);
    }

    static class LazyState {
        Color bgColor;
        Color fgColor;
        Font font;
        int graphicHints;
        int lineWidth;
        Clipping relativeClip;

        LazyState() {
        }
    }

    static class RectangleClipping
    implements Clipping {
        private float top;
        private float left;
        private float bottom;
        private float right;

        RectangleClipping(float left, float top, float right, float bottom) {
            this.left = left;
            this.right = right;
            this.bottom = bottom;
            this.top = top;
        }

        RectangleClipping(org.eclipse.swt.graphics.Rectangle rect) {
            this.left = rect.x;
            this.top = rect.y;
            this.right = rect.x + rect.width;
            this.bottom = rect.y + rect.height;
        }

        RectangleClipping(Rectangle rect) {
            this.left = rect.x;
            this.top = rect.y;
            this.right = rect.right();
            this.bottom = rect.bottom();
        }

        public Rectangle getBoundingBox(Rectangle rect) {
            rect.x = (int)this.left;
            rect.y = (int)this.top;
            rect.width = (int)Math.ceil(this.right) - rect.x;
            rect.height = (int)Math.ceil(this.bottom) - rect.y;
            return rect;
        }

        public Clipping getCopy() {
            return new RectangleClipping(this.left, this.top, this.right, this.bottom);
        }

        public void intersect(int left, int top, int right, int bottom) {
            this.left = Math.max(this.left, (float)left);
            this.right = Math.min(this.right, (float)right);
            this.top = Math.max(this.top, (float)top);
            this.bottom = Math.min(this.bottom, (float)bottom);
            if (right < left || bottom < top) {
                right = left - 1;
                bottom = top - 1;
            }
        }

        public void scale(float horz, float vert) {
            this.left /= horz;
            this.right /= horz;
            this.top /= vert;
            this.bottom /= vert;
        }

        public void setOn(GC gc, int translateX, int translateY) {
            int xInt = (int)Math.floor(this.left);
            int yInt = (int)Math.floor(this.top);
            gc.setClipping(xInt + translateX, yInt + translateY, (int)Math.ceil(this.right) - xInt, (int)Math.ceil(this.bottom) - yInt);
        }

        public void translate(float dx, float dy) {
            this.left += dx;
            this.right += dx;
            this.top += dy;
            this.bottom += dy;
        }
    }

    static class State
    extends LazyState
    implements Cloneable {
        float[] affineMatrix;
        int alpha;
        int dx;
        int dy;
        int[] lineDash;
        Pattern bgPattern;
        Pattern fgPattern;

        State() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public void copyFrom(State state) {
            this.bgColor = state.bgColor;
            this.fgColor = state.fgColor;
            this.lineWidth = state.lineWidth;
            this.dx = state.dx;
            this.dy = state.dy;
            this.bgPattern = state.bgPattern;
            this.fgPattern = state.fgPattern;
            this.font = state.font;
            this.lineDash = state.lineDash;
            this.graphicHints = state.graphicHints;
            this.affineMatrix = state.affineMatrix;
            this.relativeClip = state.relativeClip;
            this.alpha = state.alpha;
        }
    }
}

