/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal.graph;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.draw2d.graph.SubgraphBoundary;
import org.eclipse.draw2d.internal.graph.GraphVisitor;

public class ConvertCompoundGraph
extends GraphVisitor {
    private void addContainmentEdges(CompoundDirectedGraph graph) {
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = graph.nodes.getNode(i);
            Subgraph parent = node.getParent();
            if (parent != null) {
                if (node instanceof Subgraph) {
                    Subgraph sub = (Subgraph)node;
                    this.connectHead(graph, sub.head, parent);
                    this.connectTail(graph, sub.tail, parent);
                } else {
                    this.connectHead(graph, node, parent);
                    this.connectTail(graph, node, parent);
                }
            }
            ++i;
        }
    }

    int buildNestingTreeIndices(NodeList nodes, int base) {
        int i = 0;
        while (i < nodes.size()) {
            Node node = (Node)nodes.get(i);
            if (node instanceof Subgraph) {
                Subgraph s = (Subgraph)node;
                s.nestingTreeMin = base;
                base = this.buildNestingTreeIndices(s.members, base);
            }
            node.nestingIndex = base++;
            ++i;
        }
        return base++;
    }

    private void connectHead(CompoundDirectedGraph graph, Node node, Subgraph parent) {
        boolean connectHead = true;
        int j = 0;
        while (connectHead && j < node.incoming.size()) {
            Node ancestor = node.incoming.getEdge((int)j).source;
            if (parent.isNested(ancestor)) {
                connectHead = false;
            }
            ++j;
        }
        if (connectHead) {
            Edge e = new Edge(parent.head, node);
            e.weight = 0;
            graph.edges.add(e);
            graph.containment.add(e);
        }
    }

    private void connectTail(CompoundDirectedGraph graph, Node node, Subgraph parent) {
        boolean connectTail = true;
        int j = 0;
        while (connectTail && j < node.outgoing.size()) {
            Node ancestor = node.outgoing.getEdge((int)j).target;
            if (parent.isNested(ancestor)) {
                connectTail = false;
            }
            ++j;
        }
        if (connectTail) {
            Edge e = new Edge(node, parent.tail);
            e.weight = 0;
            graph.edges.add(e);
            graph.containment.add(e);
        }
    }

    private void convertSubgraphEndpoints(CompoundDirectedGraph graph) {
        int i = 0;
        while (i < graph.edges.size()) {
            Subgraph s;
            Edge edge = (Edge)graph.edges.get(i);
            if (edge.source instanceof Subgraph) {
                s = (Subgraph)edge.source;
                Node newSource = s.isNested(edge.target) ? s.head : s.tail;
                edge.source = newSource;
                newSource.outgoing.add(edge);
            }
            if (edge.target instanceof Subgraph) {
                s = (Subgraph)edge.target;
                Node newTarget = s.isNested(edge.source) ? s.tail : s.head;
                edge.target = newTarget;
                newTarget.incoming.add(edge);
            }
            ++i;
        }
    }

    private void replaceSubgraphsWithBoundaries(CompoundDirectedGraph graph) {
        int i = 0;
        while (i < graph.subgraphs.size()) {
            Subgraph s = (Subgraph)graph.subgraphs.get(i);
            graph.nodes.add(s.head);
            graph.nodes.add(s.tail);
            graph.nodes.remove(s);
            ++i;
        }
    }

    public void revisit(DirectedGraph g) {
        int i = 0;
        while (i < g.edges.size()) {
            Edge e = g.edges.getEdge(i);
            if (e.source instanceof SubgraphBoundary) {
                e.source.outgoing.remove(e);
                e.source = e.source.getParent();
            }
            if (e.target instanceof SubgraphBoundary) {
                e.target.incoming.remove(e);
                e.target = e.target.getParent();
            }
            ++i;
        }
    }

    public void visit(DirectedGraph dg) {
        CompoundDirectedGraph graph = (CompoundDirectedGraph)dg;
        NodeList roots = new NodeList();
        int i = 0;
        while (i < graph.nodes.size()) {
            Object node = graph.nodes.get(i);
            if (node instanceof Subgraph) {
                Subgraph s = (Subgraph)node;
                Insets padding = dg.getPadding(s);
                s.head = new SubgraphBoundary(s, padding, 0);
                s.tail = new SubgraphBoundary(s, padding, 2);
                Edge headToTail = new Edge(s.head, s.tail);
                headToTail.weight = 10;
                graph.edges.add(headToTail);
                graph.containment.add(headToTail);
                graph.subgraphs.add(s);
                if (s.getParent() == null) {
                    roots.add(s);
                }
                if (s.members.size() == 2) {
                    graph.edges.add(new Edge(s.head, s.tail));
                }
            }
            ++i;
        }
        this.buildNestingTreeIndices(roots, 0);
        this.convertSubgraphEndpoints(graph);
        this.addContainmentEdges(graph);
        this.replaceSubgraphsWithBoundaries(graph);
    }
}

