/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal.graph;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.draw2d.graph.VirtualNode;
import org.eclipse.draw2d.internal.graph.GraphUtilities;
import org.eclipse.draw2d.internal.graph.RevertableChange;

public class VirtualNodeCreation
extends RevertableChange {
    private final Edge edge;
    private final DirectedGraph graph;
    private Node[] nodes;
    private Edge[] edges;
    private static final int INNER_EDGE_X = 2;
    private static final int LONG_EDGE_X = 8;

    public VirtualNodeCreation(Edge edge, DirectedGraph graph) {
        Edge currentEdge;
        this.edge = edge;
        this.graph = graph;
        int size = edge.target.rank - edge.source.rank - 1;
        int offset = edge.source.rank + 1;
        Node prevNode = edge.source;
        this.nodes = new Node[size];
        this.edges = new Edge[size + 1];
        Insets padding = new Insets(0, edge.padding, 0, edge.padding);
        Subgraph s = GraphUtilities.getCommonAncestor(edge.source, edge.target);
        int i = 0;
        while (i < size) {
            VirtualNode currentNode = new VirtualNode("Virtual" + i + ':' + edge, s);
            this.nodes[i] = currentNode;
            currentNode.width = edge.width;
            if (s != null) {
                currentNode.nestingIndex = s.nestingIndex;
            }
            currentNode.height = 0;
            currentNode.setPadding(padding);
            currentNode.rank = offset + i;
            graph.ranks.getRank(offset + i).add(currentNode);
            currentEdge = new Edge(prevNode, currentNode, 1, edge.weight * 8);
            if (i == 0) {
                currentEdge.weight = edge.weight * 2;
                currentEdge.offsetSource = edge.offsetSource;
            }
            this.edges[i] = currentEdge;
            graph.edges.add(this.edges[i]);
            graph.nodes.add(currentNode);
            prevNode = currentNode;
            ++i;
        }
        currentEdge = new Edge(prevNode, edge.target, 1, edge.weight * 2);
        currentEdge.offsetTarget = edge.offsetTarget;
        Edge edge2 = currentEdge;
        this.edges[this.edges.length - 1] = edge2;
        graph.edges.add(edge2);
        graph.removeEdge(edge);
    }

    public void revert() {
        this.edge.start = this.edges[0].start;
        this.edge.end = this.edges[this.edges.length - 1].end;
        this.edge.vNodes = new NodeList();
        int i = 0;
        while (i < this.edges.length) {
            this.graph.removeEdge(this.edges[i]);
            ++i;
        }
        i = 0;
        while (i < this.nodes.length) {
            this.edge.vNodes.add(this.nodes[i]);
            this.graph.removeNode(this.nodes[i]);
            ++i;
        }
        this.edge.source.outgoing.add(this.edge);
        this.edge.target.incoming.add(this.edge);
        this.graph.edges.add(this.edge);
    }
}

