/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.SharedMessages;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Display;

public class ZoomManager {
    public static final int ANIMATE_NEVER = 0;
    public static final int ANIMATE_ZOOM_IN_OUT = 1;
    private List listeners = new ArrayList();
    private double multiplier = 1.0;
    private ScalableFigure pane;
    private Viewport viewport;
    private double zoom = 1.0;
    private double[] zoomLevels = new double[]{0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0};
    public static final String FIT_HEIGHT = SharedMessages.FitHeightAction_Label;
    public static final String FIT_WIDTH = SharedMessages.FitWidthAction_Label;
    public static final String FIT_ALL = SharedMessages.FitAllAction_Label;
    private List zoomLevelContributions = Collections.EMPTY_LIST;
    DecimalFormat format = new DecimalFormat("####%");

    public ZoomManager(ScalableFigure pane, Viewport viewport) {
        this.pane = pane;
        this.viewport = viewport;
    }

    public ZoomManager(ScalableFreeformLayeredPane pane, Viewport viewport) {
        this.pane = pane;
        this.viewport = viewport;
    }

    public void addZoomListener(ZoomListener listener) {
        this.listeners.add(listener);
    }

    public boolean canZoomIn() {
        return this.getZoom() < this.getMaxZoom();
    }

    public boolean canZoomOut() {
        return this.getZoom() > this.getMinZoom();
    }

    protected void fireZoomChanged() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ZoomListener)iter.next()).zoomChanged(this.zoom);
        }
    }

    private double getFitXZoomLevel(int which) {
        ScalableFigure fig = this.getScalableFigure();
        Dimension available = this.getViewport().getClientArea().getSize();
        Dimension desired = fig instanceof FreeformFigure ? ((FreeformFigure)fig).getFreeformExtent().getCopy().union(0, 0).getSize() : fig.getPreferredSize().getCopy();
        desired.width -= fig.getInsets().getWidth();
        desired.height -= fig.getInsets().getHeight();
        while (fig != this.getViewport()) {
            available.width -= fig.getInsets().getWidth();
            available.height -= fig.getInsets().getHeight();
            fig = fig.getParent();
        }
        double scaleX = (double)available.width * this.zoom / (double)desired.width;
        double scaleY = (double)available.height * this.zoom / (double)desired.height;
        if (which == 0) {
            return scaleX;
        }
        if (which == 1) {
            return scaleY;
        }
        return Math.min(scaleX, scaleY);
    }

    protected double getFitHeightZoomLevel() {
        return this.getFitXZoomLevel(1);
    }

    protected double getFitPageZoomLevel() {
        return this.getFitXZoomLevel(2);
    }

    protected double getFitWidthZoomLevel() {
        return this.getFitXZoomLevel(0);
    }

    public double getMaxZoom() {
        return this.getZoomLevels()[this.getZoomLevels().length - 1];
    }

    public double getMinZoom() {
        return this.getZoomLevels()[0];
    }

    public double getUIMultiplier() {
        return this.multiplier;
    }

    public double getNextZoomLevel() {
        int i = 0;
        while (i < this.zoomLevels.length) {
            if (this.zoomLevels[i] > this.zoom) {
                return this.zoomLevels[i];
            }
            ++i;
        }
        return this.getMaxZoom();
    }

    public ScalableFreeformLayeredPane getPane() {
        Assert.isTrue((boolean)(this.pane instanceof ScalableFreeformLayeredPane));
        return (ScalableFreeformLayeredPane)this.pane;
    }

    public double getPreviousZoomLevel() {
        int i = 1;
        while (i < this.zoomLevels.length) {
            if (this.zoomLevels[i] >= this.zoom) {
                return this.zoomLevels[i - 1];
            }
            ++i;
        }
        return this.getMinZoom();
    }

    public ScalableFigure getScalableFigure() {
        return this.pane;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public double getZoom() {
        return this.zoom;
    }

    public String getZoomAsText() {
        String newItem = this.format.format(this.zoom * this.multiplier);
        return newItem;
    }

    public List getZoomLevelContributions() {
        return this.zoomLevelContributions;
    }

    public double[] getZoomLevels() {
        return this.zoomLevels;
    }

    public String[] getZoomLevelsAsText() {
        String[] zoomLevelStrings = new String[this.zoomLevels.length + this.zoomLevelContributions.size()];
        int i = 0;
        while (i < this.zoomLevels.length) {
            zoomLevelStrings[i] = this.format.format(this.zoomLevels[i] * this.multiplier);
            ++i;
        }
        if (this.zoomLevelContributions != null) {
            i = 0;
            while (i < this.zoomLevelContributions.size()) {
                zoomLevelStrings[i + this.zoomLevels.length] = (String)this.zoomLevelContributions.get(i);
                ++i;
            }
        }
        return zoomLevelStrings;
    }

    protected void primSetZoom(double zoom) {
        Point p1 = this.getViewport().getClientArea().getCenter();
        Point p2 = p1.getCopy();
        Point p = this.getViewport().getViewLocation();
        double prevZoom = this.zoom;
        this.zoom = zoom;
        this.pane.setScale(zoom);
        this.fireZoomChanged();
        this.getViewport().validate();
        p2.scale(zoom / prevZoom);
        Dimension dif = p2.getDifference(p1);
        p.x += dif.width;
        p.y += dif.height;
        this.setViewLocation(p);
    }

    public void removeZoomListener(ZoomListener listener) {
        this.listeners.remove(listener);
    }

    public void setUIMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public void setViewLocation(Point p) {
        this.viewport.setViewLocation(p.x, p.y);
    }

    public void setZoom(double zoom) {
        zoom = Math.min(this.getMaxZoom(), zoom);
        zoom = Math.max(this.getMinZoom(), zoom);
        if (this.zoom != zoom) {
            this.primSetZoom(zoom);
        }
    }

    public void setZoomAnimationStyle(int style) {
    }

    public void setZoomAsText(String zoomString) {
        if (zoomString.equalsIgnoreCase(FIT_HEIGHT)) {
            this.primSetZoom(this.getFitHeightZoomLevel());
            this.viewport.getUpdateManager().performUpdate();
            this.viewport.setViewLocation(this.viewport.getHorizontalRangeModel().getValue(), this.viewport.getVerticalRangeModel().getMinimum());
        } else if (zoomString.equalsIgnoreCase(FIT_ALL)) {
            this.primSetZoom(this.getFitPageZoomLevel());
            this.viewport.getUpdateManager().performUpdate();
            this.viewport.setViewLocation(this.viewport.getHorizontalRangeModel().getMinimum(), this.viewport.getVerticalRangeModel().getMinimum());
        } else if (zoomString.equalsIgnoreCase(FIT_WIDTH)) {
            this.primSetZoom(this.getFitWidthZoomLevel());
            this.viewport.getUpdateManager().performUpdate();
            this.viewport.setViewLocation(this.viewport.getHorizontalRangeModel().getMinimum(), this.viewport.getVerticalRangeModel().getValue());
        } else {
            try {
                if (zoomString.charAt(zoomString.length() - 1) == '%') {
                    zoomString = zoomString.substring(0, zoomString.length() - 1);
                }
                double newZoom = Double.parseDouble(zoomString) / 100.0;
                this.setZoom(newZoom / this.multiplier);
            }
            catch (Exception exception) {
                Display.getCurrent().beep();
            }
        }
    }

    public void setZoomLevelContributions(List contributions) {
        this.zoomLevelContributions = contributions;
    }

    public void setZoomLevels(double[] zoomLevels) {
        this.zoomLevels = zoomLevels;
    }

    public void zoomIn() {
        this.setZoom(this.getNextZoomLevel());
    }

    public void zoomTo(Rectangle rect) {
    }

    public void zoomOut() {
        this.setZoom(this.getPreviousZoomLevel());
    }
}

