/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.graph.Vertex;

class Segment {
    Vertex start;
    Vertex end;

    Segment(Vertex start, Vertex end) {
        this.start = start;
        this.end = end;
    }

    double cosine(Segment otherSegment) {
        double cos = (double)((this.start.x - this.end.x) * (otherSegment.end.x - otherSegment.start.x) + (this.start.y - this.end.y) * (otherSegment.end.y - otherSegment.start.y)) / (this.getLength() * otherSegment.getLength());
        double sin = (this.start.x - this.end.x) * (otherSegment.end.y - otherSegment.start.y) - (this.start.y - this.end.y) * (otherSegment.end.x - otherSegment.start.x);
        if (sin < 0.0) {
            return 1.0 + cos;
        }
        return -(1.0 + cos);
    }

    private long cross(int x1, int y1, int x2, int y2) {
        return x1 * y2 - x2 * y1;
    }

    long crossProduct(Segment otherSegment) {
        return (this.start.x - this.end.x) * (otherSegment.end.y - this.end.y) - (this.start.y - this.end.y) * (otherSegment.end.x - this.end.x);
    }

    private double getLength() {
        return this.end.getDistance(this.start);
    }

    double getSlope() {
        if (this.end.x - this.start.x >= 0) {
            return this.end.y - this.start.y;
        }
        return -(this.end.y - this.start.y);
    }

    boolean intersects(int sx, int sy, int tx, int ty) {
        int su_x = this.start.x - sx;
        int su_y = this.start.y - sy;
        int sv_x = this.end.x - sx;
        int sv_y = this.end.y - sy;
        int st_x = sx - tx;
        int st_y = sy - ty;
        long product = this.cross(sv_x, sv_y, st_x, st_y) * this.cross(st_x, st_y, su_x, su_y);
        if (product >= 0L) {
            int uvx = this.end.x - this.start.x;
            int uvy = this.end.y - this.start.y;
            int tux = this.start.x - tx;
            int tuy = this.start.y - ty;
            product = this.cross(-su_x, -su_y, uvx, uvy) * this.cross(uvx, uvy, tux, tuy);
            boolean intersects = product <= 0L;
            return intersects;
        }
        return false;
    }

    boolean intersects(Point s, Point t) {
        return this.intersects(s.x, s.y, t.x, t.y);
    }

    public String toString() {
        return this.start + "---" + this.end;
    }
}

