/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.text.Bidi;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowUtilities;
import org.eclipse.swt.graphics.TextLayout;

public class BidiProcessor {
    public static final BidiProcessor INSTANCE = new BidiProcessor();
    private StringBuffer bidiText = new StringBuffer();
    private List list = new ArrayList();
    private int orientation = 0x2000000;

    private BidiProcessor() {
    }

    public void add(FlowFigure fig, String str) {
        if (fig == null || str == null || str.length() == 0) {
            return;
        }
        if (this.bidiText == null) {
            this.bidiText = new StringBuffer();
        }
        this.list.add(new StringInfoHolder(fig, this.bidiText.length(), str.length()));
        this.bidiText.append(str);
    }

    public void addControlText(String str) {
        if (this.bidiText == null) {
            this.bidiText = new StringBuffer();
        }
        this.bidiText.append(str);
    }

    private void assignResults(int[] levels) {
        int offsetIndex = 1;
        StringInfoHolder prevInfo = null;
        StringInfoHolder info = null;
        int i = 0;
        while (i < this.list.size()) {
            info = (StringInfoHolder)this.list.get(i);
            while (levels[offsetIndex] <= info.offset) {
                if ((offsetIndex += 2) >= levels.length) break;
            }
            int startingIndex = (offsetIndex -= 2) - 1;
            while (levels[offsetIndex] <= info.offset + info.length) {
                if ((offsetIndex += 2) >= levels.length) break;
            }
            int endingIndex = offsetIndex -= 2;
            int[] results = new int[endingIndex - startingIndex + 1];
            System.arraycopy(levels, startingIndex, results, 0, results.length);
            int j = 1;
            while (j < results.length) {
                results[j] = Math.max(0, results[j] - info.offset);
                j += 2;
            }
            info.fig.setBidiValues(results);
            if (prevInfo != null && levels[startingIndex + 1] != info.offset && levels[offsetIndex - 1] % 2 == 1 && this.isArabic(this.bidiText.charAt(info.offset)) && this.isArabic(this.bidiText.charAt(prevInfo.offset + prevInfo.length - 1))) {
                info.fig.setPrependJoiner(true);
                prevInfo.fig.setAppendJoiner(true);
            }
            prevInfo = info;
            ++i;
        }
    }

    private boolean isArabic(char c) {
        return Character.getDirectionality(c) == 2 || c == '\u200d';
    }

    public void process() {
        if (this.bidiText != null && this.bidiText.length() != 0) {
            char[] chars = new char[this.bidiText.length()];
            this.bidiText.getChars(0, this.bidiText.length(), chars, 0);
            if (Bidi.requiresBidi(chars, 0, chars.length - 1)) {
                int[] levels = new int[16];
                TextLayout layout = FlowUtilities.getTextLayout();
                layout.setOrientation(this.orientation);
                layout.setText(this.bidiText.toString());
                int j = 0;
                int offset = 0;
                int prevLevel = -1;
                int i = 0;
                while (i < chars.length) {
                    int newLevel = layout.getLevel(i);
                    if (newLevel != prevLevel) {
                        if (j + 2 > levels.length) {
                            int[] temp = levels;
                            levels = new int[levels.length * 2];
                            System.arraycopy(temp, 0, levels, 0, temp.length);
                        }
                        levels[j++] = newLevel;
                        levels[j++] = offset;
                        prevLevel = newLevel;
                    }
                    ++offset;
                    ++i;
                }
                if (j != levels.length) {
                    int[] newLevels = new int[j];
                    System.arraycopy(levels, 0, newLevels, 0, j);
                    levels = newLevels;
                }
                this.assignResults(levels);
            }
        }
        this.bidiText = null;
        this.list.clear();
    }

    public void setOrientation(int newOrientation) {
        this.orientation = newOrientation;
    }

    private static class StringInfoHolder {
        private FlowFigure fig;
        private int offset;
        private int length;

        StringInfoHolder(FlowFigure fig, int offset, int length) {
            this.fig = fig;
            this.offset = offset;
            this.length = length;
        }
    }
}

