/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.text.BidiProcessor;
import org.eclipse.draw2d.text.BlockBox;
import org.eclipse.draw2d.text.BlockFlowLayout;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowFigureLayout;

public class BlockFlow
extends FlowFigure {
    private int aligment = 1;
    final BlockBox blockBox = this.createBlockBox();
    private int orientation = 0;
    private boolean validateBidi;

    protected void contributeBidi(BidiProcessor proc) {
        proc.add(this, "\u2029");
    }

    BlockBox createBlockBox() {
        return new BlockBox();
    }

    protected FlowFigureLayout createDefaultFlowLayout() {
        return new BlockFlowLayout(this);
    }

    public int getBidiOrientation() {
        if (this.orientation != 0) {
            return this.orientation;
        }
        IFigure parent = this.getParent();
        while (parent != null && !(parent instanceof BlockFlow)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return ((BlockFlow)parent).getBidiOrientation();
        }
        return 0x2000000;
    }

    protected BlockBox getBlockBox() {
        return this.blockBox;
    }

    public int getHorizontalAligment() {
        return this.aligment & 7;
    }

    protected void invalidateBidi() {
    }

    public void postValidate() {
        this.setBounds(this.getBlockBox().toRectangle().expand(this.getInsets()));
        List v = this.getChildren();
        int i = 0;
        while (i < v.size()) {
            ((FlowFigure)v.get(i)).postValidate();
            ++i;
        }
    }

    protected void revalidateBidi(IFigure origin) {
        if (!this.validateBidi) {
            this.validateBidi = true;
            Iterator iter = this.getChildren().iterator();
            while (iter.hasNext()) {
                FlowFigure flowFig = (FlowFigure)iter.next();
                flowFig.invalidateBidi();
            }
        }
    }

    public void setBidiOrientation(int newOrientation) {
        if (newOrientation == 0x2000000 || newOrientation == 0x4000000 || newOrientation == 0) {
            this.orientation = newOrientation;
        }
    }

    public void setHorizontalAligment(int value) {
        if (value != 1 && value != 4 && value != 2) {
            throw new IllegalArgumentException("Horizontal Aligment must be one of: LEFT, CENTER, RIGHT");
        }
        this.aligment &= 0xFFFFFFF8;
        this.aligment |= value;
        this.revalidate();
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public void validate() {
        if (this.validateBidi) {
            BidiProcessor.INSTANCE.setOrientation(this.getBidiOrientation());
            super.contributeBidi(BidiProcessor.INSTANCE);
            BidiProcessor.INSTANCE.process();
            this.validateBidi = false;
        }
        super.validate();
    }
}

