/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.Iterator;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BidiProcessor;
import org.eclipse.draw2d.text.FlowContext;
import org.eclipse.draw2d.text.FlowFigureLayout;

public abstract class FlowFigure
extends Figure {
    private int[] bidiLevels;

    public FlowFigure() {
        this.setLayoutManager(this.createDefaultFlowLayout());
    }

    public void add(IFigure child, Object constraint, int index) {
        super.add(child, constraint, index);
        FlowFigure ff = (FlowFigure)child;
        ff.setFlowContext((FlowContext)((Object)this.getLayoutManager()));
        this.revalidateBidi(this);
    }

    public boolean addLeadingWordRequirements(int[] width) {
        return true;
    }

    protected void contributeBidi(BidiProcessor proc) {
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            ((FlowFigure)iter.next()).contributeBidi(proc);
        }
    }

    protected abstract FlowFigureLayout createDefaultFlowLayout();

    public int[] getBidiValues() {
        return this.bidiLevels;
    }

    protected void invalidateBidi() {
        this.bidiLevels = null;
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            FlowFigure flowFig = (FlowFigure)iter.next();
            flowFig.invalidateBidi();
        }
    }

    public abstract void postValidate();

    public void remove(IFigure figure) {
        super.remove(figure);
        this.revalidateBidi(this);
    }

    protected void revalidateBidi(IFigure origin) {
        if (this.getParent() != null) {
            ((FlowFigure)this.getParent()).revalidateBidi(origin);
        }
    }

    public void setAppendJoiner(boolean append) {
    }

    protected void setBidiValues(int[] levels) {
        this.bidiLevels = levels;
    }

    public void setBounds(Rectangle r) {
        if (this.getBounds().equals(r)) {
            return;
        }
        this.erase();
        this.bounds.x = r.x;
        this.bounds.y = r.y;
        this.bounds.width = r.width;
        this.bounds.height = r.height;
        this.fireMoved();
        this.repaint();
    }

    public void setFlowContext(FlowContext flowContext) {
        ((FlowFigureLayout)this.getLayoutManager()).setFlowContext(flowContext);
    }

    public void setPrependJoiner(boolean prepend) {
    }
}

