/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.text.BreakIterator;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

class FlowUtilities
extends FigureUtilities {
    private static int ELLIPSIS_SIZE;
    private static TextLayout layout;

    FlowUtilities() {
    }

    static int findPreviousNonWS(String str, int index) {
        if (index == -1) {
            return index;
        }
        --index;
        while (index > 0 && Character.isWhitespace(str.charAt(index))) {
            --index;
        }
        return index;
    }

    public static int getTextForSpace(TextFragmentBox frag, String string, Font font, int availableWidth, float avg, int wrapping) {
        int result;
        frag.truncated = false;
        if (string.length() == 0) {
            frag.length = 0;
            FlowUtilities.setupFragment(frag, font, string);
            return 0;
        }
        FontMetrics metrics = FigureUtilities.getFontMetrics(font);
        BreakIterator breakItr = BreakIterator.getLineInstance();
        breakItr.setText(string);
        int min = wrapping == 0 ? Math.max(1, FlowUtilities.findPreviousNonWS(string, breakItr.next()) + 1) : 1;
        int max = string.length() + 1;
        if ((double)avg == 0.0) {
            avg = metrics.getAverageCharWidth();
        }
        int winNL = string.indexOf("\r\n");
        int macNL = string.indexOf(13);
        int unixNL = string.indexOf(10);
        if (macNL == winNL) {
            macNL = -1;
        }
        if (winNL != -1 && unixNL == winNL + 1) {
            unixNL = -1;
        }
        if (winNL != -1) {
            max = Math.min(max, (winNL += 2) + 1);
        }
        if (unixNL != -1) {
            max = Math.min(max, ++unixNL + 1);
        }
        if (macNL != -1) {
            max = Math.min(max, ++macNL + 1);
        }
        int guess = 0;
        int guessSize = 0;
        TextLayout textLayout = null;
        if (frag.isBidi()) {
            textLayout = FlowUtilities.getTextLayout();
            textLayout.setFont(font);
            textLayout.setText(string);
        }
        while (max - min > 1) {
            if ((guess += Math.round((float)(availableWidth - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = frag.isBidi() ? textLayout.getBounds((int)0, (int)(guess - 1)).width : FigureUtilities.getTextExtents((String)string.substring((int)0, (int)guess), (Font)font).width - 1) <= availableWidth) {
                min = guess;
                continue;
            }
            max = guess;
        }
        boolean needToSetLength = true;
        if (min == winNL) {
            result = min - 2;
        } else if (min == unixNL || min == macNL) {
            result = min - 1;
        } else if (min == string.length() || breakItr.isBoundary(max - 1) || FlowUtilities.isLineBreakingMark(string.charAt(max - 1))) {
            result = min;
        } else {
            result = breakItr.preceding(max - 1);
            if (result == 0) {
                switch (wrapping) {
                    case 1: {
                        result = min;
                        break;
                    }
                    case 2: {
                        ELLIPSIS_SIZE = FigureUtilities.getStringExtents((String)"...", (Font)font).width - 1;
                        int truncatedWidth = availableWidth - ELLIPSIS_SIZE;
                        if (truncatedWidth > 0) {
                            FlowUtilities.getTextForSpace(frag, string, font, truncatedWidth, avg, 1);
                            if (frag.width > truncatedWidth) {
                                frag.length = 0;
                            }
                        } else {
                            frag.length = 0;
                        }
                        needToSetLength = false;
                        frag.truncated = true;
                        result = FlowUtilities.findPreviousNonWS(string, breakItr.following(max - 1)) + 1;
                    }
                }
            }
        }
        if (needToSetLength) {
            frag.length = result;
        }
        FlowUtilities.setupFragment(frag, font, string);
        if (textLayout != null) {
            textLayout.setText("");
        }
        return result;
    }

    static TextLayout getTextLayout() {
        if (layout == null) {
            layout = new TextLayout((Device)Display.getDefault());
        }
        return layout;
    }

    static boolean isLineBreakingMark(char c) {
        boolean result;
        boolean bl = result = c == '-' || Character.isWhitespace(c);
        if (!result) {
            BreakIterator breakItr = BreakIterator.getLineInstance();
            breakItr.setText("a" + c + "a");
            result = breakItr.isBoundary(2);
        }
        return result;
    }

    static void setupFragment(TextFragmentBox frag, Font f, String s) {
        int width;
        if (s.length() == 0 || frag.length == 0) {
            width = 0;
        } else if (frag.isBidi()) {
            TextLayout textLayout = FlowUtilities.getTextLayout();
            textLayout.setFont(f);
            textLayout.setText(s);
            width = textLayout.getBounds((int)0, (int)(frag.length - 1)).width;
        } else {
            width = FigureUtilities.getStringExtents((String)s.substring((int)0, (int)frag.length), (Font)f).width - 1;
        }
        FontMetrics fm = FigureUtilities.getFontMetrics(f);
        frag.setHeight(fm.getHeight() + fm.getLeading());
        frag.setAscent(fm.getAscent() + fm.getLeading());
        if (frag.truncated) {
            width += ELLIPSIS_SIZE;
        }
        frag.setWidth(width);
    }
}

