/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BidiProcessor;
import org.eclipse.draw2d.text.ContentBox;
import org.eclipse.draw2d.text.FlowContext;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowFigureLayout;
import org.eclipse.swt.graphics.Image;

public class ImageFlow
extends FlowFigure {
    private ContentBox box = new ContentBox();
    private FlowContext context;
    private Image img;

    public ImageFlow() {
    }

    public ImageFlow(Image img) {
        this();
        this.setImage(img);
    }

    protected void contributeBidi(BidiProcessor proc) {
        proc.add(this, "\ufffc");
    }

    protected FlowFigureLayout createDefaultFlowLayout() {
        return null;
    }

    protected void layout() {
        int[] bidiValues = this.getBidiValues();
        if (bidiValues != null) {
            this.box.setBidiLevel(bidiValues[0]);
        } else {
            this.box.setBidiLevel(-1);
        }
        if (this.img != null) {
            org.eclipse.swt.graphics.Rectangle bounds = this.img.getBounds();
            this.box.width = bounds.width;
            this.box.height = bounds.height;
        } else {
            this.box.height = 0;
            this.box.width = 0;
        }
        this.context.addToCurrentLine(this.box);
    }

    protected void paintFigure(Graphics graphics) {
        graphics.drawImage(this.img, this.box.x, this.box.y);
    }

    public void postValidate() {
        this.setBounds(new Rectangle(this.box.x, this.box.y, this.box.width, this.box.height));
    }

    public void setFlowContext(FlowContext flowContext) {
        this.context = flowContext;
    }

    public void setImage(Image image) {
        if (this.img != image) {
            this.img = image;
            this.revalidate();
            this.repaint();
        }
    }
}

