/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BlockBox;
import org.eclipse.draw2d.text.CompositeBox;
import org.eclipse.draw2d.text.ContentBox;
import org.eclipse.draw2d.text.FlowBox;

public class LineBox
extends CompositeBox {
    private int ascent = 0;

    private void buildBidiTree(FlowBox box, BidiLevelNode node, List branches) {
        if (box instanceof CompositeBox) {
            List children = ((CompositeBox)box).getFragments();
            int i = 0;
            while (i < children.size()) {
                this.buildBidiTree((FlowBox)children.get(i), node, branches);
                ++i;
            }
            if (box != this) {
                branches.add(box);
            }
        } else {
            ContentBox leafBox = (ContentBox)box;
            while (leafBox.getBidiLevel() < node.level) {
                node = node.pop();
            }
            while (leafBox.getBidiLevel() > node.level) {
                node = node.push();
            }
            node.add(leafBox);
        }
    }

    public void commit() {
        int baseline = this.getBaseline();
        int xLocation = this.x;
        if (this.isBidi()) {
            BidiLevelNode root = new BidiLevelNode();
            ArrayList branches = new ArrayList();
            this.buildBidiTree(this, root, branches);
            ArrayList result = new ArrayList();
            root.emit(result);
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                FlowBox box = (FlowBox)iter.next();
                box.x = xLocation;
                xLocation += box.width;
                box.makeBaseline(baseline);
            }
            int i = 0;
            while (i < branches.size()) {
                CompositeBox parent = (CompositeBox)branches.get(i);
                Rectangle bounds = new Rectangle(0, 1, 0, 1);
                Iterator iter2 = parent.getFragments().iterator();
                while (iter2.hasNext()) {
                    FlowBox child = (FlowBox)iter2.next();
                    bounds.union(child.x, 1, child.width, 1);
                }
                parent.x = bounds.x;
                parent.width = bounds.width;
                parent.makeBaseline(baseline);
                ++i;
            }
        } else {
            this.contiguousCommit(this, this.x, baseline);
        }
    }

    private void contiguousCommit(FlowBox box, int x, int baseline) {
        box.x = x;
        box.makeBaseline(baseline);
        if (box instanceof BlockBox) {
            return;
        }
        if (box instanceof CompositeBox) {
            List fragments = ((CompositeBox)box).getFragments();
            int i = 0;
            while (i < fragments.size()) {
                FlowBox child = (FlowBox)fragments.get(i);
                this.contiguousCommit(child, x, baseline);
                x += child.width;
                ++i;
            }
        }
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getAvailableWidth() {
        if (this.recommendedWidth < 0) {
            return Integer.MAX_VALUE;
        }
        return this.recommendedWidth - this.width;
    }

    protected void resetInfo() {
        super.resetInfo();
        this.ascent = 0;
    }

    protected void unionInfo(FlowBox blockInfo) {
        int descent = this.height - this.ascent;
        this.ascent = Math.max(this.ascent, blockInfo.getAscent());
        this.height = this.ascent + Math.max(descent, blockInfo.getDescent());
        this.width += blockInfo.width;
    }

    private static class BidiLevelNode
    extends ArrayList {
        private int level;
        private final BidiLevelNode parent;

        BidiLevelNode() {
            this(null, 0);
        }

        BidiLevelNode(BidiLevelNode parent, int level) {
            this.parent = parent;
            this.level = level;
        }

        void emit(List list) {
            if (this.level % 2 == 1) {
                int i = this.size() - 1;
                while (i >= 0) {
                    Object child = this.get(i);
                    if (child instanceof BidiLevelNode) {
                        BidiLevelNode node = (BidiLevelNode)child;
                        node.emit(list);
                    } else {
                        list.add(child);
                    }
                    --i;
                }
            } else {
                int i = 0;
                while (i < this.size()) {
                    Object child = this.get(i);
                    if (child instanceof BidiLevelNode) {
                        BidiLevelNode node = (BidiLevelNode)child;
                        node.emit(list);
                    } else {
                        list.add(child);
                    }
                    ++i;
                }
            }
        }

        BidiLevelNode pop() {
            return this.parent;
        }

        BidiLevelNode push() {
            Object last;
            if (!this.isEmpty() && (last = this.get(this.size() - 1)) instanceof BidiLevelNode && ((BidiLevelNode)last).level == this.level + 1) {
                return (BidiLevelNode)last;
            }
            BidiLevelNode child = new BidiLevelNode(this, this.level + 1);
            this.add(child);
            return child;
        }
    }
}

