/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.text.BreakIterator;
import java.util.List;
import org.eclipse.draw2d.text.FlowUtilities;
import org.eclipse.draw2d.text.LineBox;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.draw2d.text.TextLayout;
import org.eclipse.swt.graphics.Font;

public class ParagraphTextLayout
extends TextLayout {
    public static final int WORD_WRAP_HARD = 0;
    public static final int WORD_WRAP_SOFT = 1;
    public static final int WORD_WRAP_TRUNCATE = 2;
    private int wrappingStyle = 0;

    public ParagraphTextLayout(TextFlow flow) {
        super(flow);
    }

    public ParagraphTextLayout(TextFlow flow, int style) {
        this(flow);
        this.wrappingStyle = style;
    }

    protected String[] breakText(String text, int[] levels) {
        if (levels == null || levels.length == 2) {
            return new String[]{text};
        }
        String[] results = new String[levels.length / 2];
        int i = 0;
        while (i < results.length) {
            int start = i * 2 + 1;
            int end = start + 2;
            results[i] = end < levels.length ? text.substring(levels[start], levels[end]) : text.substring(levels[start]);
            ++i;
        }
        return results;
    }

    protected float getAverageCharWidth(TextFragmentBox fragment) {
        if (fragment.width != 0 && fragment.length != 0) {
            return (float)fragment.width / (float)fragment.length;
        }
        return 0.0f;
    }

    protected void layout() {
        TextFlow textFlow = (TextFlow)this.getFlowFigure();
        List fragments = textFlow.getFragments();
        Font font = textFlow.getFont();
        int i = 0;
        int offset = 0;
        int length = 0;
        int[] bidiValues = textFlow.getBidiValues();
        String[] strings = this.breakText(textFlow.getText(), bidiValues);
        strings[0] = textFlow.prependJoiner(strings[0]);
        strings[strings.length - 1] = textFlow.appendJoiner(strings[strings.length - 1]);
        int j = 0;
        while (j < strings.length) {
            String string = strings[j];
            while (string.length() > 0) {
                LineBox currentLine;
                TextFragmentBox fragment = this.getFragment(i, fragments);
                float prevAvgCharWidth = this.getAverageCharWidth(fragment);
                fragment.width = 0;
                fragment.length = 0;
                fragment.offset = offset;
                fragment.truncated = false;
                fragment.setBidiLevel(bidiValues == null ? -1 : bidiValues[j * 2]);
                while (true) {
                    if (!(currentLine = this.context.getCurrentLine()).isOccupied() && this.context.getConsumeSpaceOnNewLine() && Character.isWhitespace(string.charAt(0))) {
                        string = string.substring(1);
                        ++offset;
                        ++fragment.offset;
                    }
                    length = FlowUtilities.getTextForSpace(fragment, string, font, currentLine.getAvailableWidth(), prevAvgCharWidth, this.wrappingStyle);
                    if (fragment.width <= currentLine.getAvailableWidth() || !currentLine.isOccupied() || this.context.getContinueOnSameLine()) break;
                    this.context.endLine();
                }
                if (length != string.length()) {
                    if (string.substring(length).startsWith("\r\n")) {
                        length += 2;
                    } else if (Character.isWhitespace(string.charAt(length))) {
                        ++length;
                    } else if (Character.isWhitespace(string.charAt(length - 1))) {
                        --fragment.length;
                        FlowUtilities.setupFragment(fragment, font, string);
                    }
                    this.context.addToCurrentLine(fragment);
                } else {
                    int lookAheadWidth = -1;
                    int availableWidth = this.context.getCurrentLine().getAvailableWidth() - fragment.width;
                    if (!FlowUtilities.isLineBreakingMark(string.charAt(length - 1)) && !this.context.getContinueOnSameLine() && (lookAheadWidth = this.lookAhead(strings, j + 1)) > availableWidth) {
                        BreakIterator breakFinder = BreakIterator.getLineInstance();
                        breakFinder.setText(string);
                        int index = breakFinder.preceding(length - 1);
                        if (index > 0) {
                            length = index;
                            fragment.length = index;
                            int oldWidth = fragment.width;
                            FlowUtilities.setupFragment(fragment, font, string);
                            lookAheadWidth += oldWidth - fragment.width;
                        }
                    }
                    if (Character.isWhitespace(string.charAt(length - 1))) {
                        if (lookAheadWidth == -1) {
                            lookAheadWidth = this.lookAhead(strings, j + 1);
                        }
                        if (lookAheadWidth > availableWidth) {
                            --fragment.length;
                            FlowUtilities.setupFragment(fragment, font, string);
                        }
                    }
                    this.context.addToCurrentLine(fragment);
                    if (this.wrappingStyle == 0 && !FlowUtilities.isLineBreakingMark(string.charAt(length - 1))) {
                        if (lookAheadWidth == -1) {
                            lookAheadWidth = this.lookAhead(strings, j + 1);
                        }
                        this.context.setContinueOnSameLine(lookAheadWidth != 0);
                    }
                    this.context.setConsumeSpaceOnNewLine(true);
                }
                string = string.substring(length);
                offset += length;
                if (string.length() > 0 || fragment.truncated || currentLine.getAvailableWidth() <= 0 && !this.context.getContinueOnSameLine()) {
                    this.context.endLine();
                }
                ++i;
            }
            ++j;
        }
        while (i < fragments.size()) {
            fragments.remove(fragments.size() - 1);
        }
    }

    private int lookAhead(String[] strings, int startingIndex) {
        String rest = "";
        int k = startingIndex;
        while (k < strings.length) {
            rest = String.valueOf(rest) + strings[k];
            ++k;
        }
        int[] width = new int[1];
        TextFlow textFlow = (TextFlow)this.getFlowFigure();
        if (!textFlow.addLeadingWordWidth(rest, width)) {
            this.context.getWordWidthFollowing(textFlow, width);
        }
        return width[0];
    }
}

