/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.text.BreakIterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BidiProcessor;
import org.eclipse.draw2d.text.FlowFigureLayout;
import org.eclipse.draw2d.text.FlowUtilities;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.TextLayout;

public class TextFlow
extends InlineFlow {
    static final String ELLIPSIS = "...";
    static final int SELECT_ALL = 1;
    static final int SELECT_PARTIAL = 2;
    private boolean prependJoiner;
    private boolean appendJoiner;
    private int selectBegin = -1;
    private int selectEnd = -1;
    private String text;

    public TextFlow() {
        this(new String());
    }

    public TextFlow(String s) {
        this.text = s;
    }

    public String addJoiners(String text) {
        text = this.prependJoiner(text);
        return this.appendJoiner(text);
    }

    public boolean addLeadingWordRequirements(int[] width) {
        return this.addLeadingWordWidth(this.getText(), width);
    }

    boolean addLeadingWordWidth(String text, int[] width) {
        boolean result;
        BreakIterator spaceFinder = BreakIterator.getLineInstance();
        text = "a" + text + "a";
        spaceFinder.setText(text);
        int index = FlowUtilities.findPreviousNonWS(text, spaceFinder.next());
        boolean bl = result = index < text.length() - 1;
        if (index == text.length() - 1) {
            --index;
        }
        if (index + 1 == 1) {
            return result;
        }
        text = text.substring(1, index + 1);
        if (this.getBidiValues() == null) {
            width[0] = width[0] + (FlowUtilities.getStringExtents((String)text, (Font)this.getFont()).width - 1);
        } else {
            TextLayout textLayout = FlowUtilities.getTextLayout();
            textLayout.setText(text);
            width[0] = width[0] + textLayout.getBounds().width;
        }
        return result;
    }

    public String appendJoiner(String text) {
        if (this.appendJoiner) {
            text = String.valueOf(text) + "\u200d";
        }
        return text;
    }

    protected void contributeBidi(BidiProcessor proc) {
        proc.add(this, this.getText());
    }

    protected FlowFigureLayout createDefaultFlowLayout() {
        return new ParagraphTextLayout(this);
    }

    private int findNextLineOffset(Point p) {
        if (this.getBounds().bottom() < p.y) {
            return -1;
        }
        TextFragmentBox box = null;
        int i = 0;
        while (i < this.fragments.size()) {
            box = (TextFragmentBox)this.fragments.get(i);
            if (box.getBaseline() > p.y) break;
            box = null;
            ++i;
        }
        if (box == null) {
            return -1;
        }
        TextLayout layout = FlowUtilities.getTextLayout();
        layout.setOrientation(0x2000000);
        layout.setFont(this.getFont());
        layout.setText(this.addJoiners(this.text).substring(box.offset, box.offset + box.length));
        int[] trailing = new int[1];
        int layoutOffset = layout.getOffset(p.x - box.x, p.y - box.y, trailing) + trailing[0];
        layout.setText("");
        return box.offset + layoutOffset;
    }

    private int findPreviousLineOffset(Point p) {
        if (this.getBounds().y > p.y) {
            return -1;
        }
        TextFragmentBox box = null;
        int i = this.fragments.size() - 1;
        while (i >= 0) {
            box = (TextFragmentBox)this.fragments.get(i);
            if (box.getBaseline() < p.y) break;
            --i;
        }
        if (box == null) {
            return -1;
        }
        TextLayout layout = FlowUtilities.getTextLayout();
        layout.setOrientation(0x2000000);
        layout.setFont(this.getFont());
        layout.setText(this.addJoiners(this.text).substring(box.offset, box.offset + box.length));
        int[] trailing = new int[1];
        int layoutOffset = layout.getOffset(p.x - box.x, p.y - box.y, trailing) + trailing[0];
        layout.setText("");
        return box.offset + layoutOffset;
    }

    public Rectangle getCaretPlacement(int offset, boolean trailing) {
        TextFragmentBox box;
        if (offset < 0 || offset > this.text.length()) {
            throw new IllegalArgumentException("Offset: " + offset + " is invalid");
        }
        int i = this.fragments.size();
        do {
            box = (TextFragmentBox)this.fragments.get(--i);
        } while (offset < box.offset && i > 0);
        offset -= box.offset;
        offset = Math.min(box.length, offset);
        TextLayout layout = FlowUtilities.getTextLayout();
        layout.setOrientation(0x2000000);
        layout.setFont(this.getFont());
        String substring = this.addJoiners(this.text).substring(box.offset, box.offset + box.length);
        layout.setText(substring);
        Point where = new Point(layout.getLocation(offset, trailing));
        layout.setText("");
        FontMetrics fm = FigureUtilities.getFontMetrics(this.getFont());
        return new Rectangle(where.x + box.x, where.y + box.y, 1, fm.getAscent() + fm.getLeading() + fm.getDescent());
    }

    public int getFirstOffsetForLine(int y) {
        int i = 0;
        while (i < this.fragments.size()) {
            TextFragmentBox box = (TextFragmentBox)this.fragments.get(i);
            if (y >= box.y && y < box.y + box.getHeight()) {
                return box.offset;
            }
            ++i;
        }
        return -1;
    }

    public int getLastOffsetForLine(int y) {
        int i = this.fragments.size() - 1;
        while (i >= 0) {
            TextFragmentBox box = (TextFragmentBox)this.fragments.get(i);
            if (y >= box.y && y < box.y + box.getHeight()) {
                return box.offset + box.length;
            }
            --i;
        }
        return -1;
    }

    public int getNextOffset(Point p, boolean down) {
        if (down) {
            return this.findNextLineOffset(p);
        }
        return this.findPreviousLineOffset(p);
    }

    public int getOffset(Point p, int[] trailing) {
        if (!this.getBounds().contains(p)) {
            return -1;
        }
        int i = this.fragments.size() - 1;
        while (i >= 0) {
            TextFragmentBox box = (TextFragmentBox)this.fragments.get(i);
            if (box.containsPoint(p.x, p.y)) {
                String substring = this.addJoiners(this.text).substring(box.offset, box.offset + box.length);
                TextLayout layout = FlowUtilities.getTextLayout();
                layout.setOrientation(0x2000000);
                layout.setFont(this.getFont());
                layout.setText(substring);
                int result = layout.getOffset(p.x - box.x, p.y - box.y, trailing);
                layout.setText("");
                return result + trailing[0] + box.offset;
            }
            --i;
        }
        return -1;
    }

    public String getText() {
        return this.text;
    }

    protected void invalidateBidi() {
        super.invalidateBidi();
        this.prependJoiner = false;
        this.appendJoiner = false;
    }

    public boolean isTextTruncated() {
        int i = 0;
        while (i < this.fragments.size()) {
            if (((TextFragmentBox)this.fragments.get((int)i)).truncated) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void paintFigure(Graphics g) {
        g.getClip(Rectangle.SINGLETON);
        int yStart = Rectangle.SINGLETON.y;
        int yEnd = Rectangle.SINGLETON.bottom();
        String text = this.addJoiners(this.getText());
        int i = 0;
        while (i < this.fragments.size()) {
            TextFragmentBox frag = (TextFragmentBox)this.fragments.get(i);
            if (yStart <= frag.y + frag.getHeight() + 1) {
                if (yEnd < frag.y) break;
                int selectType = this.selectBegin == -1 ? 0 : (this.selectEnd < frag.offset ? 0 : (this.selectBegin > frag.offset + frag.length ? 0 : (this.selectBegin <= frag.offset && this.selectEnd >= frag.offset + frag.length ? 1 : 2)));
                String draw = frag.truncated ? String.valueOf(text.substring(frag.offset, frag.offset + frag.length)) + ELLIPSIS : text.substring(frag.offset, frag.offset + frag.length);
                if (frag.isBidi()) {
                    draw = "\u202e" + draw;
                }
                if (!this.isEnabled()) {
                    Color fgColor = g.getForegroundColor();
                    g.setForegroundColor(ColorConstants.buttonLightest);
                    this.paintText(g, draw, frag.x + 1, frag.y + 1, -1, -1, 0, frag.isBidi());
                    g.setForegroundColor(ColorConstants.buttonDarker);
                    this.paintText(g, draw, frag.x, frag.y, -1, -1, 0, frag.isBidi());
                    g.setForegroundColor(fgColor);
                } else {
                    int start = -1;
                    int end = -1;
                    if (selectType == 1) {
                        start = 0;
                        end = frag.length - 1;
                    } else if (selectType == 2) {
                        start = this.selectBegin - frag.offset;
                        end = this.selectEnd - frag.offset;
                    }
                    this.paintText(g, draw, frag.x, frag.y, start, end, selectType, frag.isBidi());
                }
            }
            ++i;
        }
    }

    private void paintText(Graphics g, String text, int x, int y, int selectionStart, int selectionEnd, int selectionType, boolean isBidi) {
        if (isBidi || selectionType == 2) {
            TextLayout layout = FlowUtilities.getTextLayout();
            layout.setOrientation(0x2000000);
            layout.setFont(g.getFont());
            layout.setText(text);
            g.drawTextLayout(layout, x, y, selectionStart, selectionEnd, null, null);
            layout.setText("");
        } else if (selectionType == 1) {
            Color fg = g.getForegroundColor();
            Color bg = g.getBackgroundColor();
            g.setForegroundColor(ColorConstants.menuForegroundSelected);
            g.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            g.fillString(text, x, y);
            g.setForegroundColor(fg);
            g.setBackgroundColor(bg);
        } else {
            g.drawString(text, x, y);
        }
    }

    public String prependJoiner(String text) {
        if (this.prependJoiner) {
            text = "\u200d" + text;
        }
        return text;
    }

    public void setAppendJoiner(boolean append) {
        this.appendJoiner = append;
    }

    public void setPrependJoiner(boolean prepend) {
        this.prependJoiner = prepend;
    }

    public void setSelection(int begin, int end) {
        boolean repaint = false;
        --end;
        if (this.selectBegin == begin) {
            if (this.selectEnd == end) {
                return;
            }
            repaint = true;
        } else {
            repaint = this.selectBegin != this.selectEnd || begin != end;
        }
        this.selectBegin = begin;
        this.selectEnd = end;
        if (repaint) {
            this.repaint();
        }
    }

    public void setText(String s) {
        if (s != null && !s.equals(this.text)) {
            this.text = s;
            this.revalidateBidi(this);
            this.revalidate();
            this.repaint();
        }
    }
}

