/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchImages;

public class DeleteAction
extends SelectionAction {
    public static final String ID = "delete";

    public DeleteAction(IEditorPart editor) {
        this((IWorkbenchPart)editor);
    }

    public DeleteAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
    }

    protected void init() {
        super.init();
        this.setText(GEFMessages.DeleteAction_Label);
        this.setToolTipText(GEFMessages.DeleteAction_Tooltip);
        this.setId(ActionFactory.DELETE.getId());
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_DELETE_DISABLED"));
        this.setEnabled(false);
    }

    public DeleteAction(IEditorPart editor, String label) {
        super((IWorkbenchPart)editor);
        this.setText(label);
    }

    public Command createDeleteCommand(List objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof EditPart)) {
            return null;
        }
        GroupRequest deleteReq = new GroupRequest(ID);
        CompoundCommand compoundCmd = new CompoundCommand(GEFMessages.DeleteAction_ActionDeleteCommandName);
        int i = 0;
        while (i < objects.size()) {
            EditPart object = (EditPart)objects.get(i);
            Command cmd = object.getCommand(deleteReq);
            if (cmd != null) {
                compoundCmd.add(cmd);
            }
            ++i;
        }
        return compoundCmd;
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createDeleteCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void run() {
        this.execute(this.createDeleteCommand(this.getSelectedObjects()));
    }
}

