/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.text.BidiProcessor;
import org.eclipse.draw2d.text.BlockBox;
import org.eclipse.draw2d.text.BlockFlowLayout;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowFigureLayout;

public class BlockFlow
extends FlowFigure {
    private int aligment = 1;
    final BlockBox blockBox = this.createBlockBox();
    private int orientation = 0;
    private boolean bidiValid;

    protected void contributeBidi(BidiProcessor proc) {
        proc.addControlText("\u2029");
    }

    BlockBox createBlockBox() {
        return new BlockBox();
    }

    protected FlowFigureLayout createDefaultFlowLayout() {
        return new BlockFlowLayout(this);
    }

    public int getOrientation() {
        if (this.orientation != 0) {
            return this.orientation;
        }
        IFigure parent = this.getParent();
        while (parent != null && !(parent instanceof BlockFlow)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return ((BlockFlow)parent).getOrientation();
        }
        return 0x2000000;
    }

    protected BlockBox getBlockBox() {
        return this.blockBox;
    }

    public int getHorizontalAligment() {
        return this.aligment & 7;
    }

    protected void invalidateBidi() {
    }

    public void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        if (this.selectionStart != -1) {
            graphics.restoreState();
            graphics.setXORMode(true);
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.fillRectangle(this.getBounds());
        }
    }

    public void postValidate() {
        this.setBounds(this.getBlockBox().toRectangle().expand(this.getInsets()));
    }

    public void revalidate() {
        BlockFlowLayout layout = (BlockFlowLayout)this.getLayoutManager();
        layout.blockContentsChanged();
        super.revalidate();
    }

    protected void revalidateBidi(IFigure origin) {
        if (this.bidiValid) {
            this.bidiValid = false;
            this.revalidate();
        }
    }

    public void setOrientation(int orientation) {
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation == 0x4000000 || orientation == 0x2000000 ? orientation : 0;
        this.revalidate();
    }

    public void setHorizontalAligment(int value) {
        if (value != 1 && value != 4 && value != 2) {
            throw new IllegalArgumentException("Horizontal Aligment must be one of: LEFT, CENTER, RIGHT");
        }
        this.aligment &= 0xFFFFFFF8;
        this.aligment |= value;
        this.revalidate();
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public void validate() {
        if (!this.bidiValid) {
            BidiProcessor.INSTANCE.setOrientation(this.getOrientation());
            super.contributeBidi(BidiProcessor.INSTANCE);
            BidiProcessor.INSTANCE.process();
            this.bidiValid = true;
        }
        super.validate();
    }
}

