/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.text.FlowBox;

public abstract class CompositeBox
extends FlowBox {
    protected List fragments = new ArrayList();
    int recommendedWidth = -1;

    public void add(FlowBox block) {
        this.fragments.add(block);
        this.unionInfo(block);
    }

    public void clear() {
        this.fragments.clear();
        this.resetInfo();
    }

    public List getFragments() {
        return this.fragments;
    }

    public int getRecommendedWidth() {
        return this.recommendedWidth;
    }

    public boolean requiresBidi() {
        Iterator iter = this.getFragments().iterator();
        while (iter.hasNext()) {
            FlowBox box = (FlowBox)iter.next();
            if (!box.requiresBidi()) continue;
            return true;
        }
        return false;
    }

    public boolean isOccupied() {
        return !this.fragments.isEmpty();
    }

    protected void resetInfo() {
        this.height = 0;
        this.width = 0;
    }

    public void setRecommendedWidth(int w) {
        this.recommendedWidth = w;
    }

    protected void unionInfo(FlowBox box) {
        int right = Math.max(this.x + this.width, box.x + box.width);
        int bottom = Math.max(this.y + this.height, box.y + box.height);
        this.x = Math.min(this.x, box.x);
        this.y = Math.min(this.y, box.y);
        this.width = right - this.x;
        this.height = bottom - this.y;
    }
}

