/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.FlowContext;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowFigureLayout;
import org.eclipse.draw2d.text.LineBox;

public abstract class FlowContainerLayout
extends FlowFigureLayout
implements FlowContext {
    protected LineBox currentLine;

    protected FlowContainerLayout(FlowFigure flowFigure) {
        super(flowFigure);
    }

    public void addToCurrentLine(FlowBox block) {
        this.getCurrentLine().add(block);
        this.setContinueOnSameLine(false);
    }

    protected void cleanup() {
        this.currentLine = null;
    }

    protected abstract void createNewLine();

    protected abstract void flush();

    public LineBox getCurrentLine() {
        if (this.currentLine == null) {
            this.createNewLine();
        }
        return this.currentLine;
    }

    public boolean getWordWidthFollowing(FlowFigure child, int[] width) {
        List children = this.getFlowFigure().getChildren();
        int index = -1;
        if (child != null) {
            index = children.indexOf(child);
        }
        int i = index + 1;
        while (i < children.size()) {
            if (((FlowFigure)children.get(i)).addLeadingWordRequirements(width)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isCurrentLineOccupied() {
        return this.currentLine != null && this.currentLine.isOccupied();
    }

    protected void layout() {
        this.preLayout();
        this.layoutChildren();
        this.flush();
        this.cleanup();
    }

    protected void layoutChildren() {
        List children = this.getFlowFigure().getChildren();
        int i = 0;
        while (i < children.size()) {
            Figure f = (Figure)children.get(i);
            if (this.forceChildInvalidation(f)) {
                f.invalidate();
            }
            f.validate();
            ++i;
        }
    }

    boolean forceChildInvalidation(Figure f) {
        return true;
    }

    protected abstract void preLayout();
}

