/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.text.BreakIterator;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.text.FlowContext;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

class FlowUtilities
extends FigureUtilities {
    static final BreakIterator LINE_BREAK = BreakIterator.getLineInstance();
    private static final BreakIterator INTERNAL_LINE_BREAK = BreakIterator.getLineInstance();
    private static int ELLIPSIS_SIZE;
    private static TextLayout layout;

    FlowUtilities() {
    }

    static boolean canBreakAfter(char c) {
        boolean result;
        boolean bl = result = Character.isWhitespace(c) || c == '-';
        if (!(result || c >= 'a' && c <= 'z')) {
            LINE_BREAK.setText(String.valueOf(c) + "a");
            result = LINE_BREAK.isBoundary(1);
        }
        return result;
    }

    private static int findFirstDelimeter(String string) {
        int macNL = string.indexOf(13);
        int unixNL = string.indexOf(10);
        if (macNL == -1) {
            macNL = Integer.MAX_VALUE;
        }
        if (unixNL == -1) {
            unixNL = Integer.MAX_VALUE;
        }
        return Math.min(macNL, unixNL);
    }

    private static float getAverageCharWidth(TextFragmentBox fragment, Font font) {
        if (fragment.width > 0 && fragment.length != 0) {
            return (float)fragment.width / (float)fragment.length;
        }
        return FigureUtilities.getFontMetrics(font).getAverageCharWidth();
    }

    static TextLayout getTextLayout() {
        if (layout == null) {
            layout = new TextLayout((Device)Display.getDefault());
        }
        return layout;
    }

    private static void initBidi(TextFragmentBox frag, String string, Font font) {
        if (frag.requiresBidi()) {
            TextLayout textLayout = FlowUtilities.getTextLayout();
            textLayout.setFont(font);
            textLayout.setText(string);
        }
    }

    private static int measureString(TextFragmentBox frag, String string, int guess, Font font) {
        if (frag.requiresBidi()) {
            return FlowUtilities.getTextLayout().getBounds((int)0, (int)(guess - 1)).width;
        }
        return FigureUtilities.getStringDimension((String)string.substring((int)0, (int)guess), (Font)font).x;
    }

    static void setupFragment(TextFragmentBox frag, Font f, String s) {
        if (frag.width == -1 || frag.truncated) {
            int width;
            if (s.length() == 0 || frag.length == 0) {
                width = 0;
            } else if (frag.requiresBidi()) {
                TextLayout textLayout = FlowUtilities.getTextLayout();
                textLayout.setFont(f);
                textLayout.setText(s);
                width = textLayout.getBounds((int)0, (int)(frag.length - 1)).width;
            } else {
                width = FigureUtilities.getStringDimension((String)s.substring((int)0, (int)frag.length), (Font)f).x;
            }
            if (frag.truncated) {
                width += ELLIPSIS_SIZE;
            }
            frag.setWidth(width);
        }
        FontMetrics fm = FigureUtilities.getFontMetrics(f);
        frag.setHeight(fm.getHeight());
        frag.setAscent(frag.getHeight() - fm.getDescent());
    }

    public static int wrapFragmentInContext(TextFragmentBox frag, String string, FlowContext context, LookAhead lookahead, Font font, int wrapping) {
        int max;
        int firstDelimiter;
        frag.truncated = false;
        int strLen = string.length();
        if (strLen == 0) {
            frag.width = -1;
            frag.length = 0;
            FlowUtilities.setupFragment(frag, font, string);
            context.addToCurrentLine(frag);
            return 0;
        }
        INTERNAL_LINE_BREAK.setText(string);
        FlowUtilities.initBidi(frag, string, font);
        float avgCharWidth = FlowUtilities.getAverageCharWidth(frag, font);
        frag.width = -1;
        int absoluteMin = 0;
        int min = 1;
        if (wrapping == 0) {
            absoluteMin = INTERNAL_LINE_BREAK.next();
            while (absoluteMin > 0 && Character.isWhitespace(string.charAt(absoluteMin - 1))) {
                --absoluteMin;
            }
            min = Math.max(absoluteMin, 1);
        }
        if ((firstDelimiter = FlowUtilities.findFirstDelimeter(string)) == 0) {
            max = 0;
            min = 0;
        } else {
            max = Math.min(strLen, firstDelimiter) + 1;
        }
        int availableWidth = context.getCurrentLine().getAvailableWidth();
        int guess = 0;
        int guessSize = 0;
        while (true) {
            if (max - min <= 1) {
                if (min != absoluteMin || !context.isCurrentLineOccupied() || context.getContinueOnSameLine() || availableWidth >= FlowUtilities.measureString(frag, string, min, font) + (min == strLen && lookahead != null ? lookahead.getWidth() : 0)) break;
                context.endLine();
                availableWidth = context.getCurrentLine().getAvailableWidth();
                max = Math.min(strLen, firstDelimiter) + 1;
                if (max - min <= 1) break;
            }
            if ((guess = (int)((float)guess + (0.5f + (float)(availableWidth - guessSize) / avgCharWidth))) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            guessSize = FlowUtilities.measureString(frag, string, guess, font);
            if (guess == strLen && lookahead != null && !FlowUtilities.canBreakAfter(string.charAt(strLen - 1)) && guessSize + lookahead.getWidth() > availableWidth) {
                max = guess;
                continue;
            }
            if (guessSize <= availableWidth) {
                min = guess;
                frag.width = guessSize;
                if (guessSize != availableWidth) continue;
                max = guess + 1;
                continue;
            }
            max = guess;
        }
        int result = min;
        if (min == strLen) {
            if (string.charAt(strLen - 1) == ' ' && lookahead.getWidth() > availableWidth - frag.width) {
                frag.length = result - 1;
                frag.width = -1;
            } else {
                frag.length = result;
            }
        } else if (min == firstDelimiter) {
            frag.length = result++;
            if (string.charAt(min) == '\r') {
                if (++min < strLen && string.charAt(min) == '\n') {
                    ++result;
                }
            } else if (string.charAt(min) == '\n') {
                ++result;
            }
        } else if (string.charAt(min) == ' ' || FlowUtilities.canBreakAfter(string.charAt(min - 1)) || INTERNAL_LINE_BREAK.isBoundary(min)) {
            frag.length = min;
            if (string.charAt(min) == ' ') {
                ++result;
            } else if (string.charAt(min - 1) == ' ') {
                --frag.length;
                frag.width = -1;
            }
        } else {
            result = INTERNAL_LINE_BREAK.preceding(min);
            if (result == 0) {
                switch (wrapping) {
                    case 1: {
                        result = min;
                        break;
                    }
                    case 2: {
                        ELLIPSIS_SIZE = FigureUtilities.getStringExtents((String)"...", (Font)font).width;
                        int truncatedWidth = availableWidth - ELLIPSIS_SIZE;
                        if (truncatedWidth > 0) {
                            while ((guessSize = FlowUtilities.measureString(frag, string, min--, font)) > truncatedWidth && min > 0) {
                            }
                            frag.length = min;
                        } else {
                            frag.length = 0;
                        }
                        frag.truncated = true;
                        result = INTERNAL_LINE_BREAK.following(max - 1);
                        break;
                    }
                    default: {
                        result = min;
                    }
                }
            }
            frag.length = result;
            if (string.charAt(result - 1) == ' ') {
                --frag.length;
            }
            frag.width = -1;
        }
        FlowUtilities.setupFragment(frag, font, string);
        context.addToCurrentLine(frag);
        if (frag.length == absoluteMin && frag.length == strLen && lookahead != null && lookahead.getWidth() > 0) {
            context.setContinueOnSameLine(true);
        }
        return result;
    }

    static interface LookAhead {
        public int getWidth();
    }
}

