/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.FlowContainerLayout;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.LineBox;

public class InlineFlowLayout
extends FlowContainerLayout {
    public InlineFlowLayout(FlowFigure flow) {
        super(flow);
    }

    public void addToCurrentLine(FlowBox block) {
        super.addToCurrentLine(block);
        ((InlineFlow)this.getFlowFigure()).getFragments().add(this.currentLine);
    }

    protected void createNewLine() {
        this.currentLine = new LineBox();
        this.setupLine(this.currentLine);
    }

    public void endLine() {
        if (this.currentLine == null) {
            return;
        }
        if (this.currentLine.isOccupied()) {
            this.getContext().addToCurrentLine(this.currentLine);
        }
        this.getContext().endLine();
        this.currentLine = null;
    }

    protected void flush() {
        if (this.currentLine != null) {
            boolean sameLine = this.getContext().getContinueOnSameLine();
            this.getContext().addToCurrentLine(this.currentLine);
            this.getContext().setContinueOnSameLine(sameLine);
        }
    }

    public boolean getContinueOnSameLine() {
        return this.getContext().getContinueOnSameLine();
    }

    public int getCurrentY() {
        return this.getCurrentLine().y;
    }

    public boolean getWordWidthFollowing(FlowFigure child, int[] width) {
        boolean result = super.getWordWidthFollowing(child, width);
        if (!result && this.getContext() != null) {
            return this.getContext().getWordWidthFollowing(this.getFlowFigure(), width);
        }
        return result;
    }

    public boolean isCurrentLineOccupied() {
        return this.currentLine != null && !this.currentLine.getFragments().isEmpty() || this.getContext().isCurrentLineOccupied();
    }

    public void preLayout() {
        ((InlineFlow)this.getFlowFigure()).getFragments().clear();
    }

    public void setContinueOnSameLine(boolean value) {
        this.getContext().setContinueOnSameLine(value);
    }

    protected void setupLine(LineBox line) {
        LineBox parent = this.getContext().getCurrentLine();
        line.x = 0;
        line.y = this.getContext().getCurrentY();
        line.setRecommendedWidth(parent.getAvailableWidth());
    }
}

