/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.text.BreakIterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BidiInfo;
import org.eclipse.draw2d.text.BidiProcessor;
import org.eclipse.draw2d.text.FlowFigureLayout;
import org.eclipse.draw2d.text.FlowUtilities;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.TextLayout;

public class TextFlow
extends InlineFlow {
    static final String ELLIPSIS = "...";
    static final int SELECT_ALL = 1;
    static final int SELECT_PARTIAL = 2;
    private BidiInfo bidiInfo;
    private int selectionEnd = -1;
    private String text;

    public TextFlow() {
        this(new String());
    }

    public TextFlow(String s) {
        this.text = s;
    }

    public boolean addLeadingWordRequirements(int[] width) {
        return this.addLeadingWordWidth(this.getText(), width);
    }

    boolean addLeadingWordWidth(String text, int[] width) {
        boolean result;
        if (text.length() == 0) {
            return false;
        }
        if (Character.isWhitespace(text.charAt(0))) {
            return true;
        }
        BreakIterator lineBreaker = FlowUtilities.LINE_BREAK;
        text = String.valueOf('a') + text + 'a';
        lineBreaker.setText(text);
        int index = lineBreaker.next() - 1;
        while (Character.isWhitespace(text.charAt(index))) {
            --index;
        }
        boolean bl = result = index < text.length() - 1;
        if (index == text.length() - 1) {
            --index;
        }
        text = text.substring(1, index + 1);
        if (this.bidiInfo == null) {
            width[0] = width[0] + FlowUtilities.getStringExtents((String)text, (Font)this.getFont()).width;
        } else {
            TextLayout textLayout = FlowUtilities.getTextLayout();
            textLayout.setFont(this.getFont());
            textLayout.setText(text);
            width[0] = width[0] + textLayout.getBounds().width;
        }
        return result;
    }

    protected void contributeBidi(BidiProcessor proc) {
        this.bidiInfo = null;
        proc.add(this, this.getText());
    }

    protected FlowFigureLayout createDefaultFlowLayout() {
        return new ParagraphTextLayout(this);
    }

    private int findNextLineOffset(Point p) {
        if (this.getBounds().bottom() < p.y) {
            return -1;
        }
        TextFragmentBox box = null;
        int i = 0;
        while (i < this.fragments.size()) {
            box = (TextFragmentBox)this.fragments.get(i);
            if (box.y > p.y) break;
            box = null;
            ++i;
        }
        if (box == null) {
            return -1;
        }
        TextLayout layout = FlowUtilities.getTextLayout();
        layout.setFont(this.getFont());
        String fragString = this.getBidiSubstring(box, i);
        layout.setText(fragString);
        int[] trailing = new int[1];
        int layoutOffset = layout.getOffset(p.x - box.x, p.y - box.y, trailing) + trailing[0];
        layout.setText("");
        return box.offset + layoutOffset;
    }

    private int findPreviousLineOffset(Point p) {
        if (this.getBounds().y > p.y) {
            return -1;
        }
        TextFragmentBox box = null;
        int i = this.fragments.size() - 1;
        while (i >= 0) {
            box = (TextFragmentBox)this.fragments.get(i);
            if (box.getBaseline() < p.y) break;
            box = null;
            --i;
        }
        if (box == null) {
            return -1;
        }
        TextLayout layout = FlowUtilities.getTextLayout();
        layout.setFont(this.getFont());
        String fragString = this.bidiInfo == null ? this.text.substring(box.offset, box.offset + box.length) : this.getBidiSubstring(box, i);
        layout.setText(fragString);
        int[] trailing = new int[1];
        int layoutOffset = layout.getOffset(p.x - box.x, p.y - box.y, trailing) + trailing[0];
        layout.setText("");
        return box.offset + (layoutOffset -= this.getBidiPrefixLength(box, i));
    }

    public BidiInfo getBidiInfo() {
        return this.bidiInfo;
    }

    private String getBidiSubstring(TextFragmentBox box, int index) {
        if (this.bidiInfo == null || box.bidiLevel < 1) {
            return this.text.substring(box.offset, box.offset + box.length);
        }
        StringBuffer buffer = new StringBuffer(box.length + 3);
        buffer.append(box.isRightToLeft() ? (char)'\u202e' : '\u202d');
        if (index == 0 && this.bidiInfo.leadingJoiner) {
            buffer.append('\u200d');
        }
        buffer.append(this.text.substring(box.offset, box.offset + box.length));
        if (index == this.fragments.size() - 1 && this.bidiInfo.trailingJoiner) {
            buffer.append('\u200d');
        }
        return buffer.toString();
    }

    public Rectangle getCaretPlacement(int offset, boolean trailing) {
        TextFragmentBox box;
        if (offset < 0 || offset > this.text.length()) {
            throw new IllegalArgumentException("Offset: " + offset + " is invalid");
        }
        int i = this.fragments.size();
        do {
            box = (TextFragmentBox)this.fragments.get(--i);
        } while (offset < box.offset && i > 0);
        if (trailing && box.offset + box.length <= offset) {
            box = (TextFragmentBox)this.fragments.get(++i);
            offset = box.offset;
            trailing = false;
        }
        offset -= box.offset;
        offset = Math.min(box.length, offset);
        TextLayout layout = FlowUtilities.getTextLayout();
        layout.setFont(this.getFont());
        String fragString = this.getBidiSubstring(box, i);
        if (this.bidiInfo != null) {
            offset += this.getBidiPrefixLength(box, i);
        }
        layout.setText(fragString);
        Point where = new Point(layout.getLocation(offset, trailing));
        layout.setText("");
        FontMetrics fm = FigureUtilities.getFontMetrics(this.getFont());
        return new Rectangle(where.x + box.x, where.y + box.y, 1, fm.getHeight());
    }

    public int getFirstOffsetForLine(int y) {
        int i = 0;
        while (i < this.fragments.size()) {
            TextFragmentBox box = (TextFragmentBox)this.fragments.get(i);
            if (y >= box.y && y < box.y + box.getHeight()) {
                return box.offset;
            }
            ++i;
        }
        return -1;
    }

    public int getLastOffsetForLine(int y) {
        int i = this.fragments.size() - 1;
        while (i >= 0) {
            TextFragmentBox box = (TextFragmentBox)this.fragments.get(i);
            if (y >= box.y && y < box.y + box.getHeight()) {
                return box.offset + box.length;
            }
            --i;
        }
        return -1;
    }

    public int getNextOffset(Point p, boolean down) {
        if (down) {
            return this.findNextLineOffset(p);
        }
        return this.findPreviousLineOffset(p);
    }

    public int getNextVisibleOffset(int offset) {
        int i = 0;
        while (i < this.fragments.size()) {
            TextFragmentBox box = (TextFragmentBox)this.fragments.get(i);
            if (box.offset + box.length > offset) {
                return Math.max(box.offset, offset + 1);
            }
            ++i;
        }
        return -1;
    }

    public int getOffset(Point p, int[] trailing) {
        if (!this.getBounds().contains(p)) {
            return -1;
        }
        int i = this.fragments.size() - 1;
        while (i >= 0) {
            TextFragmentBox box = (TextFragmentBox)this.fragments.get(i);
            if (box.containsPoint(p.x, p.y)) {
                String substring = this.getBidiSubstring(box, i);
                int bidiCorrection = 0;
                if (this.bidiInfo != null) {
                    bidiCorrection = -this.getBidiPrefixLength(box, i);
                }
                TextLayout layout = FlowUtilities.getTextLayout();
                layout.setFont(this.getFont());
                layout.setText(substring);
                int result = layout.getOffset(p.x - box.x, p.y - box.y, trailing);
                layout.setText("");
                return result + trailing[0] + box.offset + bidiCorrection;
            }
            --i;
        }
        return -1;
    }

    private int getBidiPrefixLength(TextFragmentBox box, int index) {
        if (box.bidiLevel < 1) {
            return 0;
        }
        if (index > 0 || !this.bidiInfo.leadingJoiner) {
            return 1;
        }
        return 2;
    }

    public int getPreviousVisibleOffset(int offset) {
        if (offset == -1) {
            offset = Integer.MAX_VALUE;
        }
        int i = this.fragments.size() - 1;
        while (i >= 0) {
            TextFragmentBox box = (TextFragmentBox)this.fragments.get(i);
            if (box.offset < offset) {
                return Math.min(box.offset + box.length, offset - 1);
            }
            --i;
        }
        return -1;
    }

    public String getText() {
        return this.text;
    }

    public boolean isTextTruncated() {
        int i = 0;
        while (i < this.fragments.size()) {
            if (((TextFragmentBox)this.fragments.get((int)i)).truncated) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void paintFigure(Graphics g) {
        g.getClip(Rectangle.SINGLETON);
        int yStart = Rectangle.SINGLETON.y;
        int yEnd = Rectangle.SINGLETON.bottom();
        int i = 0;
        while (i < this.fragments.size()) {
            TextFragmentBox frag = (TextFragmentBox)this.fragments.get(i);
            if (yStart <= frag.y + frag.getHeight() + 1) {
                if (yEnd < frag.y) break;
                String draw = this.getBidiSubstring(frag, i);
                if (frag.truncated) {
                    draw = String.valueOf(draw) + ELLIPSIS;
                }
                if (!this.isEnabled()) {
                    Color fgColor = g.getForegroundColor();
                    g.setForegroundColor(ColorConstants.buttonLightest);
                    this.paintText(g, draw, frag.x + 1, frag.y + 1, frag.getBidiLevel());
                    g.setForegroundColor(ColorConstants.buttonDarker);
                    this.paintText(g, draw, frag.x, frag.y, frag.getBidiLevel());
                    g.setForegroundColor(fgColor);
                } else {
                    this.paintText(g, draw, frag.x, frag.y, frag.getBidiLevel());
                }
            }
            ++i;
        }
    }

    protected void paintSelection(Graphics graphics) {
        if (this.selectionStart == -1) {
            return;
        }
        graphics.setXORMode(true);
        graphics.setBackgroundColor(ColorConstants.white);
        int i = 0;
        while (i < this.fragments.size()) {
            TextFragmentBox frag = (TextFragmentBox)this.fragments.get(i);
            if (frag.offset + frag.length > this.selectionStart) {
                if (frag.offset > this.selectionEnd) {
                    return;
                }
                if (this.selectionStart <= frag.offset && this.selectionEnd >= frag.offset + frag.length) {
                    graphics.fillRectangle(frag.x, frag.y, frag.getWidth(), frag.getHeight());
                } else if (this.selectionEnd > frag.offset && this.selectionStart < frag.offset + frag.length) {
                    int prefixCorrection = this.getBidiPrefixLength(frag, i);
                    String text = this.getBidiSubstring(frag, i);
                    TextLayout layout = FlowUtilities.getTextLayout();
                    layout.setFont(graphics.getFont());
                    layout.setText(text);
                    Rectangle rect = new Rectangle();
                    rect.setLocation(layout.getLocation((int)(Math.max((int)(this.selectionStart - frag.offset), (int)0) + prefixCorrection), (boolean)false).x, 0);
                    rect.union(layout.getLocation((int)(Math.min((int)(this.selectionEnd - frag.offset), (int)frag.length) - 1 + prefixCorrection), (boolean)true).x, 0);
                    --rect.width;
                    rect.height = frag.getHeight();
                    rect.translate(frag.x, frag.y);
                    graphics.fillRectangle(rect);
                }
            }
            ++i;
        }
    }

    private void paintText(Graphics g, String draw, int x, int y, int bidiLevel) {
        if (bidiLevel < 1) {
            g.drawString(draw, x, y);
        } else {
            TextLayout tl = FlowUtilities.getTextLayout();
            tl.setFont(g.getFont());
            tl.setText(draw);
            g.drawTextLayout(tl, x, y);
        }
    }

    public void setBidiInfo(BidiInfo info) {
        this.bidiInfo = info;
    }

    public void setSelection(int start, int end) {
        boolean repaint = false;
        if (this.selectionStart == start) {
            if (this.selectionEnd == end) {
                return;
            }
            repaint = true;
        } else {
            repaint = this.selectionStart != this.selectionEnd || start != end;
        }
        this.selectionStart = start;
        this.selectionEnd = end;
        if (repaint) {
            this.repaint();
        }
    }

    public void setText(String s) {
        if (s != null && !s.equals(this.text)) {
            this.text = s;
            this.revalidateBidi(this);
            this.revalidate();
            this.repaint();
        }
    }
}

