/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.properties;

import java.util.EventObject;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.ForwardUndoCompoundCommand;
import org.eclipse.gef.internal.ui.properties.PropertySheetEntry;
import org.eclipse.gef.internal.ui.properties.RestoreDefaultPropertyValueCommand;
import org.eclipse.gef.internal.ui.properties.SetPropertyValueCommand;
import org.eclipse.ui.views.properties.IPropertySource;

public class UndoablePropertySheetEntry
extends PropertySheetEntry {
    private CommandStackListener commandStackListener;
    protected CommandStack stack;

    public UndoablePropertySheetEntry() {
    }

    public UndoablePropertySheetEntry(CommandStack stack) {
        this.setCommandStack(stack);
    }

    protected PropertySheetEntry[] createChildEntries(int size) {
        return new UndoablePropertySheetEntry[size];
    }

    protected PropertySheetEntry createChildEntry() {
        return new UndoablePropertySheetEntry();
    }

    public void dispose() {
        if (this.stack != null) {
            this.stack.removeCommandStackListener(this.commandStackListener);
        }
        super.dispose();
    }

    protected CommandStack getCommandStack() {
        if (this.getParent() != null) {
            return ((UndoablePropertySheetEntry)this.getParent()).getCommandStack();
        }
        return this.stack;
    }

    public void resetPropertyValue() {
        CompoundCommand cc = new CompoundCommand();
        if (this.getParent() == null) {
            return;
        }
        boolean change = false;
        Object[] objects = this.getParent().getValues();
        int i = 0;
        while (i < objects.length) {
            IPropertySource source = this.getPropertySource(objects[i]);
            if (source.isPropertySet(this.getDescriptor().getId())) {
                RestoreDefaultPropertyValueCommand restoreCmd = new RestoreDefaultPropertyValueCommand();
                restoreCmd.setTarget(source);
                restoreCmd.setPropertyId(this.getDescriptor().getId());
                cc.add(restoreCmd);
                change = true;
            }
            ++i;
        }
        if (change) {
            this.getCommandStack().execute(cc);
            this.refreshFromRoot();
        }
    }

    public void setCommandStack(CommandStack stack) {
        this.stack = stack;
        this.commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject e) {
                UndoablePropertySheetEntry.this.refreshFromRoot();
            }
        };
        stack.addCommandStackListener(this.commandStackListener);
    }

    protected void setValue(Object newValue) {
        int i = 0;
        while (i < this.getValues().length) {
            this.getValues()[i] = newValue;
            ++i;
        }
        ((UndoablePropertySheetEntry)this.getParent()).valueChanged(this, new ForwardUndoCompoundCommand());
        this.refreshFromRoot();
    }

    protected void valueChanged(UndoablePropertySheetEntry child, CompoundCommand command) {
        CompoundCommand cc = new CompoundCommand();
        command.add(cc);
        int i = 0;
        while (i < this.getValues().length) {
            SetPropertyValueCommand setCommand = new SetPropertyValueCommand(child.getDisplayName());
            setCommand.setTarget(this.getPropertySource(this.getValues()[i]));
            setCommand.setPropertyId(child.getDescriptor().getId());
            setCommand.setPropertyValue(child.getValues()[i]);
            cc.add(setCommand);
            ++i;
        }
        if (this.getParent() != null) {
            ((UndoablePropertySheetEntry)this.getParent()).valueChanged(this, command);
        } else {
            this.stack.execute(command);
        }
    }
}

