/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.palette;

import org.eclipse.gef.SharedImages;
import org.eclipse.gef.Tool;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.MarqueeSelectionTool;
import org.eclipse.jface.util.Assert;

public class MarqueeToolEntry
extends ToolEntry {
    public static final int SELECT_NODES = 1;
    public static final int SELECT_CONNECTIONS = 2;
    private int selectionType;

    public MarqueeToolEntry() {
        this(GEFMessages.MarqueeTool_Label, (String)null, 1);
    }

    public MarqueeToolEntry(int type) {
        this((String)null, (String)null, type);
    }

    public MarqueeToolEntry(String label) {
        this(label, (String)null, 1);
    }

    public MarqueeToolEntry(String label, String shortDesc) {
        this(label, shortDesc, 1);
    }

    public MarqueeToolEntry(String label, String shortDesc, int type) {
        super(label, shortDesc, SharedImages.DESC_MARQUEE_TOOL_16, SharedImages.DESC_MARQUEE_TOOL_24);
        this.selectionType = type & 3;
        Assert.isTrue((this.selectionType != 0 ? 1 : 0) != 0);
        if (label == null || label.length() == 0) {
            this.setLabel(GEFMessages.MarqueeTool_Label);
        }
        if (shortDesc == null || shortDesc.length() == 0) {
            if (this.selectionType == 2) {
                this.setDescription(GEFMessages.MarqueeTool_Connections_Desc);
            } else if (this.selectionType == 1) {
                this.setDescription(GEFMessages.MarqueeTool_Nodes_Desc);
            } else {
                this.setDescription(GEFMessages.MarqueeTool_Desc);
            }
        }
        this.setUserModificationPermission(1);
    }

    public Tool createTool() {
        return new MarqueeSelectionTool(this.selectionType);
    }
}

