/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.AbstractConnectionCreationTool;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Event;

public class ConnectionCreationTool
extends AbstractConnectionCreationTool {
    static /* synthetic */ Class class$0;

    public ConnectionCreationTool() {
        this.setUnloadWhenFinished(false);
    }

    public ConnectionCreationTool(CreationFactory factory) {
        this.setFactory(factory);
        this.setUnloadWhenFinished(false);
    }

    boolean acceptConnectionFinish(KeyEvent event) {
        return this.isInState(32) && event.character == '\r';
    }

    boolean acceptConnectionStart(KeyEvent event) {
        return this.isInState(1) && event.character == '\r';
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1 && this.stateTransition(64, 0x40000000)) {
            return this.handleCreateConnection();
        }
        super.handleButtonDown(button);
        if (this.isInState(64)) {
            this.handleDrag();
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(96)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.setState(8);
            this.handleFinished();
        }
        return super.handleFocusLost();
    }

    protected boolean handleKeyDown(KeyEvent event) {
        if (this.acceptArrowKey(event)) {
            int direction = 0;
            switch (event.keyCode) {
                case 0x1000002: {
                    direction = 4;
                    break;
                }
                case 0x1000001: {
                    direction = 1;
                    break;
                }
                case 0x1000004: {
                    direction = 16;
                    break;
                }
                case 0x1000003: {
                    direction = 8;
                }
            }
            boolean consumed = false;
            if (direction != 0 && event.stateMask == 0) {
                consumed = this.navigateNextAnchor(direction);
            }
            if (!consumed) {
                event.stateMask |= 0x40000;
                event.stateMask &= 0xFFFDFFFF;
                if (this.getCurrentViewer().getKeyHandler().keyPressed(event)) {
                    this.navigateNextAnchor(0);
                    this.updateTargetRequest();
                    this.updateTargetUnderMouse();
                    Command command = this.getCommand();
                    if (command != null) {
                        this.setCurrentCommand(command);
                    }
                    return true;
                }
            }
        }
        if (event.character == '/' || event.character == '\\') {
            event.stateMask |= 0x40000;
            if (this.getCurrentViewer().getKeyHandler().keyPressed(event)) {
                this.navigateNextAnchor(0);
                return true;
            }
        }
        if (this.acceptConnectionStart(event)) {
            Command command = this.getCommand();
            if (command != null && command.canExecute()) {
                this.updateTargetUnderMouse();
                this.setConnectionSource(this.getTargetEditPart());
                ((CreateConnectionRequest)this.getTargetRequest()).setSourceEditPart(this.getTargetEditPart());
                this.setState(32);
                this.placeMouseInViewer(this.getLocation().getTranslated(6, 6));
            }
            return true;
        }
        if (this.acceptConnectionFinish(event)) {
            Command command = this.getCommand();
            if (command != null && command.canExecute()) {
                this.setState(1);
                this.placeMouseInViewer(this.getLocation().getTranslated(6, 6));
                this.eraseSourceFeedback();
                this.eraseTargetFeedback();
                this.setCurrentCommand(command);
                this.executeCurrentCommand();
            }
            return true;
        }
        return super.handleKeyDown(event);
    }

    public void mouseWheelScrolled(Event event, EditPartViewer viewer) {
        if (this.isInState(65)) {
            this.performViewerMouseWheel(event, viewer);
        }
    }

    boolean navigateNextAnchor(int direction) {
        AccessibleAnchorProvider provider;
        EditPart focus = this.getCurrentViewer().getFocusEditPart();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.AccessibleAnchorProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((provider = (AccessibleAnchorProvider)focus.getAdapter(clazz)) == null) {
            return false;
        }
        List list = this.isInState(32) ? provider.getTargetAnchorLocations() : provider.getSourceAnchorLocations();
        Point start = this.getLocation();
        int distance = Integer.MAX_VALUE;
        Point next = null;
        int i = 0;
        while (i < list.size()) {
            int d;
            Point p = (Point)list.get(i);
            if (!(p.equals((Object)start) || direction != 0 && start.getPosition(p) != direction || (d = p.getDistanceOrthogonal(start)) >= distance)) {
                distance = d;
                next = p;
            }
            ++i;
        }
        if (next != null) {
            this.placeMouseInViewer(next);
            return true;
        }
        return false;
    }
}

