/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;

class AncestorHelper
implements PropertyChangeListener,
FigureListener {
    protected final IFigure base;
    protected AncestorListener[] listeners = null;
    private int size;

    public AncestorHelper(IFigure baseFigure) {
        this.base = baseFigure;
        this.addAncestors(baseFigure);
    }

    public void addAncestorListener(AncestorListener listener) {
        if (this.size == 0) {
            this.listeners = new AncestorListener[2];
        } else {
            int i = 0;
            while (i < this.size) {
                if (this.listeners[i] == listener) {
                    return;
                }
                ++i;
            }
            if (this.size == this.listeners.length) {
                this.listeners = new AncestorListener[this.size * 2 + 1];
                System.arraycopy(this.listeners, 0, this.listeners, 0, this.size);
            }
        }
        this.listeners[this.size] = listener;
        ++this.size;
    }

    protected void addAncestors(IFigure rootFigure) {
        IFigure ancestor = rootFigure;
        while (ancestor != null) {
            ancestor.addFigureListener(this);
            ancestor.addPropertyChangeListener("parent", this);
            ancestor = ancestor.getParent();
        }
    }

    public void dispose() {
        this.removeAncestors(this.base);
        this.listeners = null;
    }

    public void figureMoved(IFigure ancestor) {
        this.fireAncestorMoved(ancestor);
    }

    protected void fireAncestorMoved(IFigure ancestor) {
        int i = 0;
        while (i < this.size) {
            this.listeners[i].ancestorMoved(ancestor);
            ++i;
        }
    }

    protected void fireAncestorAdded(IFigure ancestor) {
        int i = 0;
        while (i < this.size) {
            this.listeners[i].ancestorAdded(ancestor);
            ++i;
        }
    }

    protected void fireAncestorRemoved(IFigure ancestor) {
        int i = 0;
        while (i < this.size) {
            this.listeners[i].ancestorRemoved(ancestor);
            ++i;
        }
    }

    public int getNumberOfListeners() {
        return this.size;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("parent")) {
            IFigure oldParent = (IFigure)event.getOldValue();
            IFigure newParent = (IFigure)event.getNewValue();
            if (oldParent != null) {
                this.removeAncestors(oldParent);
                this.fireAncestorRemoved(oldParent);
            }
            if (newParent != null) {
                this.addAncestors(newParent);
                this.fireAncestorAdded(newParent);
            }
        }
    }

    public void removeAncestorListener(AncestorListener listener) {
        int i = 0;
        while (i < this.size) {
            if (this.listeners[i] == listener) {
                if (this.size == 1) {
                    this.listeners = null;
                    this.size = 0;
                } else {
                    System.arraycopy(this.listeners, i + 1, this.listeners, i, --this.size - i);
                    this.listeners[this.size] = null;
                }
                return;
            }
            ++i;
        }
    }

    protected void removeAncestors(IFigure rootFigure) {
        IFigure ancestor = rootFigure;
        while (ancestor != null) {
            ancestor.removeFigureListener(this);
            ancestor.removePropertyChangeListener("parent", this);
            ancestor = ancestor.getParent();
        }
    }
}

