/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.geometry.Rectangle;

public abstract class UpdateManager {
    private List listeners = new ArrayList();
    private boolean disposed;

    public abstract void addDirtyRegion(IFigure var1, int var2, int var3, int var4, int var5);

    public void addDirtyRegion(IFigure figure, Rectangle rect) {
        this.addDirtyRegion(figure, rect.x, rect.y, rect.width, rect.height);
    }

    public void runWithUpdate(Runnable run) {
    }

    public abstract void addInvalidFigure(IFigure var1);

    public void addUpdateListener(UpdateListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.disposed = true;
    }

    protected void firePainting(Rectangle damage, Map dirtyRegions) {
        int i = 0;
        while (i < this.listeners.size()) {
            UpdateListener listener = (UpdateListener)this.listeners.get(i);
            listener.notifyPainting(damage, dirtyRegions);
            ++i;
        }
    }

    protected void fireValidating() {
        int i = 0;
        while (i < this.listeners.size()) {
            UpdateListener listener = (UpdateListener)this.listeners.get(i);
            listener.notifyValidating();
            ++i;
        }
    }

    protected boolean isDisposed() {
        return this.disposed;
    }

    public abstract void performUpdate();

    public abstract void performUpdate(Rectangle var1);

    public void removeUpdateListener(UpdateListener listener) {
        this.listeners.remove(listener);
    }

    public abstract void setGraphicsSource(GraphicsSource var1);

    public abstract void setRoot(IFigure var1);
}

