/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal.graph;

import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.internal.graph.GraphVisitor;

public class InitialRankSolver
extends GraphVisitor {
    protected DirectedGraph graph;
    protected EdgeList candidates = new EdgeList();
    protected NodeList members = new NodeList();

    public void visit(DirectedGraph graph) {
        this.graph = graph;
        graph.edges.resetFlags();
        graph.nodes.resetFlags();
        this.solve();
    }

    protected void solve() {
        NodeList unranked = new NodeList(this.graph.nodes);
        NodeList rankMe = new NodeList();
        do {
            Node node;
            rankMe.clear();
            int i = 0;
            while (i < unranked.size()) {
                node = unranked.getNode(i);
                if (node.incoming.isCompletelyFlagged()) {
                    rankMe.add(node);
                    unranked.remove(i);
                    continue;
                }
                ++i;
            }
            if (rankMe.size() == 0) {
                throw new RuntimeException("Cycle detected in graph");
            }
            i = 0;
            while (i < rankMe.size()) {
                node = rankMe.getNode(i);
                node.rank = node.incoming.calculateRank();
                node.outgoing.setFlags(true);
                ++i;
            }
        } while (!unranked.isEmpty());
    }
}

