/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.RankList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.draw2d.internal.graph.GraphVisitor;
import org.eclipse.draw2d.internal.graph.NestingTree;
import org.eclipse.draw2d.internal.graph.NodePair;

public class SortSubgraphs
extends GraphVisitor {
    CompoundDirectedGraph g;
    NestingTree[] nestingTrees;
    Set OGedges = new HashSet();
    Set OGmembers = new HashSet();
    NodePair pair = new NodePair();

    private void breakSubgraphCycles() {
        Node node;
        ArrayList noLefts = new ArrayList();
        int index = 1;
        Iterator iter = this.OGmembers.iterator();
        while (iter.hasNext()) {
            node = (Node)iter.next();
            if (node.x != 0) continue;
            this.sortedInsert(noLefts, node);
        }
        block1: while (true) {
            if (noLefts.size() > 0) {
                node = (Node)noLefts.remove(noLefts.size() - 1);
                node.sortValue = index++;
                this.OGmembers.remove(node);
                NodeList rightOf = this.rightOf(node);
                if (rightOf == null) continue;
                int i = 0;
                while (true) {
                    if (i >= rightOf.size()) continue block1;
                    Node right = rightOf.getNode(i);
                    --right.x;
                    if (right.x == 0) {
                        this.sortedInsert(noLefts, right);
                    }
                    ++i;
                }
            }
            Node cycleRoot = null;
            double min = Double.MAX_VALUE;
            Iterator iter2 = this.OGmembers.iterator();
            while (iter2.hasNext()) {
                Node node2 = (Node)iter2.next();
                if (!(node2.sortValue < min)) continue;
                cycleRoot = node2;
                min = node2.sortValue;
            }
            if (cycleRoot != null) {
                this.sortedInsert(noLefts, cycleRoot);
                cycleRoot.x = -1;
            }
            if (cycleRoot == null) break;
        }
    }

    private void buildSubgraphOrderingGraph() {
        NestingTree entry;
        RankList ranks = this.g.ranks;
        this.nestingTrees = new NestingTree[ranks.size()];
        int r = 0;
        while (r < ranks.size()) {
            this.nestingTrees[r] = entry = NestingTree.buildNestingTreeForRank(ranks.getRank(r));
            entry.calculateSortValues();
            entry.recursiveSort(false);
            ++r;
        }
        int i = 0;
        while (i < this.nestingTrees.length) {
            entry = this.nestingTrees[i];
            this.buildSubgraphOrderingGraph(entry);
            ++i;
        }
    }

    private void buildSubgraphOrderingGraph(NestingTree entry) {
        NodePair pair = new NodePair();
        if (entry.isLeaf) {
            return;
        }
        int i = 0;
        while (i < entry.contents.size()) {
            Object right = entry.contents.get(i);
            if (right instanceof Node) {
                pair.n2 = (Node)right;
            } else {
                pair.n2 = ((NestingTree)right).subgraph;
                this.buildSubgraphOrderingGraph((NestingTree)right);
            }
            if (pair.n1 != null && !this.OGedges.contains(pair)) {
                this.OGedges.add(pair);
                this.leftToRight(pair.n1, pair.n2);
                this.OGmembers.add(pair.n1);
                this.OGmembers.add(pair.n2);
                ++pair.n2.x;
                pair = new NodePair(pair.n2, null);
            } else {
                pair.n1 = pair.n2;
            }
            ++i;
        }
    }

    private void calculateSortValues() {
        RankList ranks = this.g.ranks;
        this.g.subgraphs.resetSortValues();
        this.g.subgraphs.resetIndices();
        int r = 0;
        while (r < ranks.size()) {
            Rank rank = ranks.getRank(r);
            int j = 0;
            while (j < rank.count()) {
                Node node = rank.getNode(j);
                node.sortValue = node.index;
                Subgraph parent = node.getParent();
                while (parent != null) {
                    parent.sortValue += node.sortValue;
                    ++parent.index;
                    parent = parent.getParent();
                }
                ++j;
            }
            ++r;
        }
        int i = 0;
        while (i < this.g.subgraphs.size()) {
            Subgraph subgraph = (Subgraph)this.g.subgraphs.get(i);
            subgraph.sortValue /= (double)subgraph.index;
            ++i;
        }
    }

    private void repopulateRanks() {
        int i = 0;
        while (i < this.nestingTrees.length) {
            Rank rank = this.g.ranks.getRank(i);
            rank.clear();
            this.nestingTrees[i].repopulateRank(rank);
            ++i;
        }
    }

    private NodeList rightOf(Node left) {
        return (NodeList)left.workingData[0];
    }

    private void leftToRight(Node left, Node right) {
        this.rightOf(left).add(right);
    }

    void sortedInsert(List list, Node node) {
        int insert = 0;
        while (insert < list.size() && ((Node)list.get((int)insert)).sortValue > node.sortValue) {
            ++insert;
        }
        list.add(insert, node);
    }

    private void topologicalSort() {
        int i = 0;
        while (i < this.nestingTrees.length) {
            this.nestingTrees[i].getSortValueFromSubgraph();
            this.nestingTrees[i].recursiveSort(false);
            ++i;
        }
    }

    void init() {
        int r = 0;
        while (r < this.g.ranks.size()) {
            Rank rank = this.g.ranks.getRank(r);
            int i = 0;
            while (i < rank.count()) {
                Node n = (Node)rank.get(i);
                n.workingData[0] = new NodeList();
                ++i;
            }
            ++r;
        }
        int i = 0;
        while (i < this.g.subgraphs.size()) {
            Subgraph s = (Subgraph)this.g.subgraphs.get(i);
            s.workingData[0] = new NodeList();
            ++i;
        }
    }

    public void visit(DirectedGraph dg) {
        this.g = (CompoundDirectedGraph)dg;
        this.init();
        this.buildSubgraphOrderingGraph();
        this.calculateSortValues();
        this.breakSubgraphCycles();
        this.topologicalSort();
        this.repopulateRanks();
    }
}

