/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.text.BlockBox;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowContainerLayout;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.LineBox;

public class BlockFlowLayout
extends FlowContainerLayout {
    BlockBox blockBox;
    private boolean continueOnSameLine = false;
    private LineBox previousLine = null;
    boolean blockInvalid = false;

    public BlockFlowLayout(BlockFlow blockFlow) {
        super(blockFlow);
    }

    public void blockContentsChanged() {
        this.blockInvalid = true;
    }

    protected void cleanup() {
        super.cleanup();
        this.previousLine = null;
        this.currentLine = null;
    }

    public boolean getContinueOnSameLine() {
        return this.continueOnSameLine;
    }

    protected void createNewLine() {
        this.currentLine = new LineBox();
        this.setupLine(this.currentLine);
    }

    protected void endBlock() {
        if (this.getContext() != null) {
            this.getContext().addToCurrentLine(this.blockBox);
            this.getContext().endLine();
        }
        if (this.blockInvalid) {
            this.blockInvalid = false;
            List v = this.getFlowFigure().getChildren();
            int i = 0;
            while (i < v.size()) {
                ((FlowFigure)v.get(i)).postValidate();
                ++i;
            }
        }
    }

    public void endLine() {
        if (this.currentLine == null) {
            return;
        }
        if (!this.currentLine.isOccupied()) {
            return;
        }
        this.layoutLine();
        LineBox box = this.currentLine;
        this.currentLine = this.previousLine;
        this.previousLine = box;
        this.setupLine(this.getCurrentLine());
    }

    public int getCurrentY() {
        return this.getCurrentLine().y;
    }

    protected final BlockFlow getBlockFlow() {
        return (BlockFlow)this.getFlowFigure();
    }

    protected void layoutLine() {
        this.currentLine.x = 0;
        int alignment = this.getBlockFlow().getHorizontalAligment();
        if (this.getBlockFlow().getOrientation() == 0x4000000) {
            if (alignment == 1) {
                alignment = 4;
            } else if (alignment == 4) {
                alignment = 1;
            }
        }
        switch (alignment) {
            case 4: {
                this.currentLine.x = this.blockBox.getRecommendedWidth() - this.currentLine.getWidth();
                break;
            }
            case 2: {
                this.currentLine.x = (this.blockBox.getRecommendedWidth() - this.currentLine.getWidth()) / 2;
            }
        }
        this.currentLine.commit();
        this.blockBox.add(this.currentLine);
    }

    boolean forceChildInvalidation(Figure f) {
        return this.blockInvalid;
    }

    protected void flush() {
        if (this.currentLine != null) {
            this.layoutLine();
        }
        this.endBlock();
    }

    protected void preLayout() {
        this.setContinueOnSameLine(false);
        this.blockBox = this.getBlockFlow().getBlockBox();
        this.setupBlock();
    }

    public void setContinueOnSameLine(boolean value) {
        this.continueOnSameLine = value;
    }

    protected void setupBlock() {
        this.getContext().endLine();
        LineBox line = this.getContext().getCurrentLine();
        int recommended = line.getAvailableWidth();
        if (recommended != this.blockBox.recommendedWidth) {
            this.blockInvalid = true;
            this.blockBox.clear();
            this.blockBox.setRecommendedWidth(recommended);
        }
        this.blockBox.y = this.getContext().getCurrentY();
        this.blockBox.x = 0;
    }

    protected void setupLine(LineBox line) {
        line.clear();
        line.setRecommendedWidth(this.blockBox.getRecommendedWidth());
        line.y = this.previousLine == null ? 0 : this.previousLine.y + this.previousLine.getHeight();
    }
}

