/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowFigureLayout;
import org.eclipse.draw2d.text.InlineFlowLayout;

public class InlineFlow
extends FlowFigure {
    List fragments = new ArrayList(1);

    public boolean addLeadingWordRequirements(int[] width) {
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            if (!((FlowFigure)iter.next()).addLeadingWordRequirements(width)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPoint(int x, int y) {
        if (super.containsPoint(x, y)) {
            List frags = this.getFragments();
            int i = 0;
            while (i < frags.size()) {
                if (((FlowBox)frags.get(i)).containsPoint(x, y)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected FlowFigureLayout createDefaultFlowLayout() {
        return new InlineFlowLayout(this);
    }

    public List getFragments() {
        return this.fragments;
    }

    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        if (this.selectionStart != -1) {
            this.paintSelection(graphics);
        }
    }

    protected void paintSelection(Graphics graphics) {
        graphics.restoreState();
        graphics.setXORMode(true);
        graphics.setBackgroundColor(ColorConstants.white);
        List list = this.getFragments();
        int i = 0;
        while (i < list.size()) {
            FlowBox box = (FlowBox)list.get(i);
            graphics.fillRectangle(box.x, box.y, box.getWidth(), box.getHeight());
            ++i;
        }
    }

    public void postValidate() {
        int right;
        int left;
        List list = this.getFragments();
        int top = left = Integer.MAX_VALUE;
        int bottom = right = Integer.MIN_VALUE;
        int i = 0;
        while (i < list.size()) {
            FlowBox box = (FlowBox)list.get(i);
            left = Math.min(left, box.x);
            right = Math.max(right, box.x + box.width);
            top = Math.min(top, box.y);
            bottom = Math.max(bottom, box.y + box.height);
            ++i;
        }
        this.setBounds(new Rectangle(left, top, right - left, bottom - top));
        this.repaint();
        list = this.getChildren();
        i = 0;
        while (i < list.size()) {
            ((FlowFigure)list.get(i)).postValidate();
            ++i;
        }
    }
}

