/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.TargetingTool;
import org.eclipse.swt.graphics.Cursor;

public class CreationTool
extends TargetingTool {
    private CreationFactory factory;
    private SnapToHelper helper;
    static /* synthetic */ Class class$0;

    public CreationTool() {
        this.setDefaultCursor(SharedCursors.CURSOR_TREE_ADD);
        this.setDisabledCursor(SharedCursors.NO);
    }

    public CreationTool(CreationFactory aFactory) {
        this();
        this.setFactory(aFactory);
    }

    protected Cursor calculateCursor() {
        return super.calculateCursor();
    }

    protected Request createTargetRequest() {
        CreateRequest request = new CreateRequest();
        request.setFactory(this.getFactory());
        return request;
    }

    public void deactivate() {
        super.deactivate();
        this.helper = null;
    }

    protected String getCommandName() {
        return "create child";
    }

    protected CreateRequest getCreateRequest() {
        return (CreateRequest)this.getTargetRequest();
    }

    protected String getDebugName() {
        return "Creation Tool";
    }

    protected CreationFactory getFactory() {
        return this.factory;
    }

    protected boolean handleButtonDown(int button) {
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
            return true;
        }
        if (this.stateTransition(1, 2)) {
            this.getCreateRequest().setLocation(this.getLocation());
            this.lockTargetEditPart(this.getTargetEditPart());
            EditPart editPart = this.getTargetEditPart();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.SnapToHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.helper = (SnapToHelper)editPart.getAdapter(clazz);
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(6, 0x40000000)) {
            this.eraseTargetFeedback();
            this.unlockTargetEditPart();
            this.performCreation(button);
        }
        this.setState(0x40000000);
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(4)) {
            this.updateTargetRequest();
            this.setCurrentCommand(this.getCommand());
            this.showTargetFeedback();
        }
        return true;
    }

    protected boolean handleDragStarted() {
        return this.stateTransition(2, 4);
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.eraseTargetFeedback();
            this.setState(8);
            this.handleFinished();
            return true;
        }
        return false;
    }

    protected boolean handleHover() {
        if (this.isInState(1)) {
            this.updateAutoexposeHelper();
        }
        return true;
    }

    protected boolean handleMove() {
        this.updateTargetRequest();
        this.updateTargetUnderMouse();
        this.setCurrentCommand(this.getCommand());
        this.showTargetFeedback();
        return true;
    }

    protected void performCreation(int button) {
        this.executeCurrentCommand();
        this.selectAddedObject();
    }

    private void selectAddedObject() {
        Object model = this.getCreateRequest().getNewObject();
        if (model == null) {
            return;
        }
        EditPartViewer viewer = this.getCurrentViewer();
        Object editpart = viewer.getEditPartRegistry().get(model);
        if (editpart instanceof EditPart) {
            viewer.flush();
            viewer.select((EditPart)editpart);
        }
    }

    public void setFactory(CreationFactory factory) {
        this.factory = factory;
    }

    protected void updateTargetRequest() {
        CreateRequest req = this.getCreateRequest();
        if (this.isInState(4)) {
            Point loq = this.getStartLocation();
            Rectangle bounds = new Rectangle(loq, loq);
            bounds.union(loq.getTranslated(this.getDragMoveDelta()));
            req.setSize(bounds.getSize());
            req.setLocation(bounds.getLocation());
            req.getExtendedData().clear();
            if (!this.getCurrentInput().isAltKeyDown() && this.helper != null) {
                PrecisionRectangle baseRect = new PrecisionRectangle(bounds);
                PrecisionRectangle result = baseRect.getPreciseCopy();
                this.helper.snapRectangle((Request)req, 29, baseRect, result);
                req.setLocation(result.getLocation());
                req.setSize(result.getSize());
            }
        } else {
            req.setSize(null);
            req.setLocation(this.getLocation());
        }
    }
}

